<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  
  <xsl:output method="html" indent="yes"/>
  <xsl:strip-space elements="*"/>
    
  <xsl:include href="PopulateTemplate.xsl"/>
   <xsl:include href="AddHeader.xsl"/>
   <xsl:include href="CommonPathRef.xsl"/>
  <xsl:include href="AddOnTable.xsl"/>
  
  <xsl:param name="DependencyData" select="$RtnDoc/ItemizedOtherDeductionSch3"/>
  <!-- Schema location: common-ItemizedOtherDeductionSch3-->
  <!-- Template to display   Itemized Other Deductions Schedule -->
  
  <xsl:template name="ShowDependencyData">
  
    <!-- Itemized Other Income Schedule Data -->
    <table id="DependencyDataTbl" class="styDepTbl" style="font-size: 7pt">
      <thead class="styTableThead">
      <tr class="styDepTblHdr">         
         <th class="styDepTblCell" style="width:20mm;">Trade or Business Activity</th>         
         <th class="styDepTblCell" style="width:86mm;">Description</th>  
         <th class="styDepTblCell" style="width:35mm">Foreign Amount<br/>(should only be used when attached to 5471 Schedule C Line 16)</th>  
         <th class="styDepTblCell" style="width:35mm">Amount</th>  
         <th class="styDepTblCell" style="width:10mm;">Code</th>                                                                               
      </tr>
      </thead>
        <tfoot/>
        
       <tbody>
      <xsl:for-each select="$DependencyData/ItemizedOtherDeduction3Grp">
        <tr>
          <xsl:attribute name="class">
          <xsl:choose>
             <xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
             <xsl:otherwise>styDepTblRow2</xsl:otherwise>
          </xsl:choose>
          </xsl:attribute>
                              
       <td class="styDepTblCell" style="text-align:center; width:20mm;">
        <xsl:if test="PrincipalBusinessActivityCd">      		
               <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="PrincipalBusinessActivityCd"/>
               </xsl:call-template> 
        </xsl:if>
        <xsl:if test="InactivePrincipalBusActyCd">      		
               <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="InactivePrincipalBusActyCd"/>
               </xsl:call-template> 
     </xsl:if>
	</td>       
       <td class="styDepTblCell" style="text-align:left;width:86mm;">      		
          <xsl:call-template name="PopulateText">
            <xsl:with-param name="TargetNode" select="Desc"/>
          </xsl:call-template> 
	</td>  
       <td class="styDepTblCell" style="text-align:right; width:35mm">      		
          <xsl:call-template name="PopulateAmount">
            <xsl:with-param name="MaxSize">17</xsl:with-param>
            <xsl:with-param name="TargetNode" select="ForeignAmt"/>
          </xsl:call-template> 
	</td>  
       <td class="styDepTblCell" style="text-align:right; width: 35mm">      		
          <xsl:call-template name="PopulateAmount">
            <xsl:with-param name="TargetNode" select="Amt"/>
          </xsl:call-template> 
	</td>  
     <td class="styDepTblCell" style="text-align:center; width:10mm">      		
          <xsl:call-template name="PopulateText">
            <xsl:with-param name="TargetNode" select="Cd"/>
          </xsl:call-template> 
	</td>  							  
        </tr>
      </xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:param name="depDocTitle">
    <xsl:call-template name="PopulateDisplayName"><xsl:with-param name="TargetNode" select="$DependencyData"/></xsl:call-template>  
  </xsl:param>
  
  <!-- Main template -->
  <xsl:template match="/">
    <html>
      <head>
          <title><xsl:value-of select="$depDocTitle"/></title>

         <!-- No Browser Caching -->
         <meta http-equiv="Pragma" content="no-cache"/>
         <meta http-equiv="Cache-Control" content="no-cache"/>
         <meta http-equiv="Expires" content="0"/>
         
         <!-- No Proxy Caching -->
         <meta http-equiv="Cache-Control" content="private"/>
         
         <!-- Define Character Set -->
         <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
         <meta name="Author" content="Jason Iozzo"/>
         <meta name="Desc" content="{$depDocTitle}"/> 
                
        <script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
        <xsl:call-template name="InitJS"/>
           
        <style type="text/css">
          <xsl:if test="not($Print) or $Print=''">
            <xsl:call-template name="AddOnStyle"/>    
          </xsl:if>
        </style>
      <xsl:call-template name="GlobalStylesDep"/>
</head>    
      <body class="styBodyClass">
        <xsl:call-template name="DocumentHeaderDependency"/>
          
        <div class="styDepTitleLine">
          <span class="styDepTitle" style="width:104mm;">
            <xsl:value-of select="$depDocTitle"/>        
          </span>
        </div>
        
        <!--Adding template for left over data  -->
        <xsl:call-template name="PopulateDepCommonLeftover"><xsl:with-param name="TargetNode" select="$DependencyData"/></xsl:call-template>        
                
        <xsl:call-template name="ShowDependencyData"/>          
        <br/>                      
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>