<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>
  <xsl:strip-space elements="*"/>
    
  <xsl:include href="PopulateTemplate.xsl"/>
  <xsl:include href="CommonPathRef.xsl"/>
  <xsl:include href="AddHeader.xsl"/>  
  <xsl:include href="AddOnTable.xsl"/>
  
  <xsl:param name="DependencyData" select="$RtnDoc/ConnectedEarningsProfitsSch"/>
  <!-- Display Name is Connected Earnings And Profits Schedule 1120F -->
  <xsl:param name="depDocTitle">
    <xsl:call-template name="PopulateDisplayName">
      <xsl:with-param name="TargetNode" select="$DependencyData"/>
    </xsl:call-template>  
  </xsl:param>
      
  <xsl:template name="DependencyTemplate"> 
    <div class="styTopSectionLine">
          <div style="float:left;clear:none;"><span class="styTopSectionLineLbl">Corporation Name:</span></div>
          <div style="float:left;clear:none;">
            <xsl:call-template name="PopulateAmount">
              <xsl:with-param name="TargetNode" select="$DependencyData/CorporationName/BusinessNameLine1"/>
            </xsl:call-template>
            <br/>
            <xsl:call-template name="PopulateAmount">
              <xsl:with-param name="TargetNode" select="$DependencyData/CorporationName/BusinessNameLine2"/>
            </xsl:call-template>
          </div>
        </div>
        <div class="styTopSectionLine">
          <div style="float:left;clear:none;"><span class="styTopSectionLineLbl">Corporation EIN:</span></div>
          <div style="float:left;clear:none;">
         <xsl:choose>
                     <xsl:when test="$DependencyData/CorporationEIN">
                       <xsl:call-template name="PopulateEIN">
                          <xsl:with-param name="TargetNode" select="$DependencyData/CorporationEIN"/>
                      </xsl:call-template>
                   </xsl:when>
                  <xsl:when test="$DependencyData/MissingEINReasonCd">
                     <xsl:call-template name="PopulateText">
                        <xsl:with-param name="TargetNode" select="$DependencyData/MissingEINReasonCd"/>
                    </xsl:call-template>
                 </xsl:when>
             </xsl:choose>
          </div>
        </div>
       
 <!-- Table begin -->     
    <table class="styDepTbl" style="margin-top:4mm;width:187mm;">
      <thead class="styTableThead" style="width:187mm;">        
        <tr class="styDepTblHdr" style="width:187mm;">           
           <th class="styDepTblCell" scope="col" style="width:91mm;vertical-align: middle">
             Adjustments to the Corporations Effectively Connected Taxable Income
          </th>
           <th class="styDepTblCell" scope="col" style="width:32mm;vertical-align: middle">
             Positive Adjustments for Certain Effectively Connected Income Items that are Excluded from ECTI but Included in Computing ECEP
          </th>
          <th class="styDepTblCell" scope="col" style="width:32mm;vertical-align: middle">       
            Positive Adjustments for Certain Items Deducted in Computing ECTI but not Deducted in Computing ECEP
          </th>
          <th class="styDepTblCell" scope="col" style="width:32mm;vertical-align: middle">       
            Negative Adjustments for Certain Deductible Items that May Not be Deducted in Computing ECTI but Must be Deducted in Computing ECEP
          </th>        
                          
        </tr>
      </thead>  
      <tfoot/>
      <tbody>    
      <xsl:for-each select="$DependencyData/CorporationAdjustments">
        <tr>
          <xsl:attribute name="class">
          <xsl:choose>
             <xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
             <xsl:otherwise>styDepTblRow2</xsl:otherwise>
          </xsl:choose>
          </xsl:attribute>                          
          <td class="styDepTblCell" style="width:91mm;text-align:left;">
            <xsl:call-template name="PopulateText">
              <xsl:with-param name="TargetNode" select="AdjToCorpEffCnnctTxIDscTxt"/>
            </xsl:call-template>
          </td>  
          <td class="styDepTblCell" style="width:32mm;text-align:right;font-size:6.5pt;">
              <xsl:call-template name="PopulateAmount">
                <xsl:with-param name="TargetNode" select="AdjECIExcldECTIIncldECEPAmt"/>
              </xsl:call-template>    
          </td>
          <td class="styDepTblCell" style="width:32mm;text-align:right;font-size:6.5pt;">   
              <xsl:call-template name="PopulateAmount">
                <xsl:with-param name="TargetNode" select="AdjDedECTINotDedECEPAmt"/>
              </xsl:call-template>     
          </td>
         <td class="styDepTblCell" style="width:32mm;text-align:right;font-size:6.5pt;">   
              <xsl:call-template name="PopulateAmount">
                <xsl:with-param name="TargetNode" select="AdjDedItemNotDedECTIDedECEPAmt"/>
              </xsl:call-template>     
          </td>  
           
        </tr>
      </xsl:for-each>
      </tbody>    
    </table>
  </xsl:template>

  <!-- Main template -->
  <xsl:template match="/">
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
      <head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
         <title><xsl:value-of select="$depDocTitle"/></title>
         <!-- No Browser Caching -->
         <meta http-equiv="Pragma" content="no-cache"/>
         <meta http-equiv="Cache-Control" content="no-cache"/>
         <meta http-equiv="Expires" content="0"/>
         <!-- No Proxy Caching -->
         <meta http-equiv="Cache-Control" content="private"/>
         <!-- Define Character Set -->
         <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>        
         <meta name="Description" content="{$depDocTitle}"/>        
        
        <script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
        <xsl:call-template name="InitJS"/>    
          <style type="text/css">
            <xsl:if test="not($Print) or $Print=''">
              <xsl:call-template name="AddOnStyle"/>    
            </xsl:if>
          </style>
        <xsl:call-template name="GlobalStylesDep"/>
      </head>
    
      <body class="styBodyClass">    
        <xsl:call-template name="DocumentHeaderDependency"/>        
        <div class="styDepTitleLine">
          <span class="styDepTitle">
        <span style="width:110mm;">
                <xsl:value-of select="$depDocTitle"/>
                </span>
            <span style="width:2mm;"/>  
          </span>
        </div>        
        
        <xsl:call-template name="PopulateDepCommonLeftover"><xsl:with-param name="TargetNode" select="$DependencyData"/></xsl:call-template>                    
        <xsl:call-template name="DependencyTemplate"/>            

      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>