<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>
  <xsl:strip-space elements="*"/>
  <xsl:include href="PopulateTemplate.xsl"/>
  <xsl:include href="CommonPathRef.xsl"/>
  <xsl:include href="AddHeader.xsl"/>
  <xsl:include href="AddOnTable.xsl"/>
  <xsl:param name="PCPISData" select="$RtnDoc/PrpsdChgPoolingInventoriesStmt"/>
  <!--  - Form 3115 displays as - Proposed Change in Pooling Inventories Statement - -->
  <xsl:template name="ShowPCPIS">
    <!-- Itemized Other Income Schedule Data -->
    <table id="PCPISTbl" class="styDepTblLandscape">
      <thead class="styDepTableThead">
        <tr class="styDepTblHdr">
          <th class="styDepTblCell" style="font-size: 9pt;" scope="col" >Present Use Description of the Contents of the Dollar-Value Pool Used</th>
          <th class="styDepTblCell" style="width:13mm;font-size: 9pt;" scope="col" >Present Use Base Year</th>
          <th class="styDepTblCell" style="font-size: 9pt;" scope="col">Proposed Use Description of the Contents of the Dollar-Value Pool Used</th>
          <th class="styDepTblCell" style="width:13mm;font-size: 9pt;" scope="col" >Proposed Use Base Year</th>
        </tr>
      </thead>
      <tfoot/>
      <tbody>
        <xsl:for-each select="$PCPISData/PrpsdChgPoolingInventoriesInfo">  
          <tr>
            <!-- Set row background color -->
            <xsl:attribute name="class">
              <xsl:choose>
                <xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
                <xsl:otherwise>styDepTblRow2</xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <td class="styDepTblCell" scope="col" style="text-align:left;font-size: 9pt;">
                        <xsl:call-template name="PopulateText">
                          <xsl:with-param name="TargetNode" select="PresentUseDollarVlPoolUsedDesc"/>
                        </xsl:call-template>
            </td>
            <td class="styDepTblCell" scope="col" style="width:13mm;text-align:center;font-size: 9pt;">
              <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="PresentUseBaseYr"/>
              </xsl:call-template>
            </td>
            <td class="styDepTblCell" scope="col" style="text-align:left;font-size: 9pt;">
              <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="ProposedUseDolVlPoolUsedDesc"/>
              </xsl:call-template>
            </td>
            <td class="styDepTblCell" scope="col" style="width:13mm;text-align:center;font-size: 9pt;">
              <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="ProposedUseBaseYr"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:for-each> 
      </tbody>
    </table>
  </xsl:template>
    <xsl:param name="depDocTitle">
      <xsl:call-template name="PopulateDisplayName">
        <xsl:with-param name="TargetNode" select="$PCPISData"/>
      </xsl:call-template>  
    </xsl:param> 
    <!-- Main template -->
    <xsl:template match="/">
      <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
        <head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
          <title>
            <xsl:value-of select="$depDocTitle"/>
          </title>
          <!-- No Browser Caching -->
          <meta http-equiv="Pragma" content="no-cache"/>
          <meta http-equiv="Cache-Control" content="no-cache"/>
          <meta http-equiv="Expires" content="0"/>
          <!-- No Proxy Caching -->
          <meta http-equiv="Cache-Control" content="private"/>
          <!-- Define Character Set -->
          <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
          <meta name="Author" content="Chris Sinderson"/>
          <meta name="Description" content="{$depDocTitle}"/>
          <script language="JavaScript" src="{$ScriptPath}/FormDisplay.js"/>
          <xsl:call-template name="InitJS"/>
          <style type="text/css">
            <xsl:if test="not($Print) or $Print=''">
              <xsl:call-template name="AddOnStyle"/>    
            </xsl:if>
          </style>
          <xsl:call-template name="GlobalStylesDep"/>
        </head>
        <body class="styBodyClass">
          <xsl:call-template name="DocumentHeaderDependencyLandscape"/>  
          <div class="styDepTitleLine">
        <span class="styDepTitle"  style="padding-right:2mm;">
            <xsl:value-of select="$depDocTitle"/>
          </span>        
      </div>
          <xsl:call-template name="PopulateDepCommonLeftoverLandscape">
            <xsl:with-param name="TargetNode" select="$PCPISData"/>
          </xsl:call-template>
          <span style="height:5px;"/>
          <!-- Transform Itemized Other Income Schedule -->
          <xsl:call-template name="ShowPCPIS"/>
          <br/>
        </body>
      </html>
    </xsl:template>
 </xsl:stylesheet>