<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="PopulateTemplate.xsl"/>
	<xsl:include href="CommonPathRef.xsl"/>
	<xsl:include href="AddHeader.xsl"/>
	<xsl:include href="AddOnTable.xsl"/>
	<xsl:include href="IRS3800Style.xsl"/>
	<xsl:output method="html" indent="yes"/> 
	<xsl:strip-space elements="*"/>
	<!-- Defines the stage of the data, e.g. original or latest -->
	<xsl:param name="Form3800Data" select="$RtnDoc/IRS3800"/>
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/> 
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($Form3800Data)"/>
					</xsl:call-template>
				</title>
				<!-- No Browser Caching -->
				<meta http-equiv="Pragma" content="no-cache"/>
				<meta http-equiv="Cache-Control" content="no-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private"/>
				<!-- Define Character Set -->
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
				<meta name="Description" content="IRS Form 3800"/>
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
				<xsl:call-template name="InitJS"/>
				<style type="text/css">
					<xsl:if test="not($Print) or $Print=''">
						<xsl:call-template name="IRS3800Style"/>
						<xsl:call-template name="AddOnStyle"/>
					</xsl:if>
				</style>
				<xsl:call-template name="GlobalStylesForm"/>
			</head>
			<body class="styBodyClass">
				<form name="Form3800" style="font-size:7pt;">
					<!-- BEGIN WARNING LINE -->
					<div class="styGenericDiv" style=" width:256mm;">
						<xsl:call-template name="DocumentHeaderLandscape"/>
					</div>
					<!-- END WARNING LINE -->
					<!-- Begin Form Number and Name -->
					<div class="styTBB" style="width:256mm;height:21mm;">
						<div class="styFNBox" style="width:29mm;height:21mm;">
							<div style="height:13mm;">
               Form<span class="styFormNumber"> 3800</span>
								<br/>
								<!--General Dependency Push Pin-->
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$Form3800Data"/>
								</xsl:call-template>
							</div>
							<div style="height:8mm;padding-top:.75mm;">
								<span class="styAgency">Department of the Treasury</span>
								<br/>
								<span class="styAgency">Internal Revenue Service
								</span>
							</div>
						</div>
						<div class="styFTBox" style="width:175mm;height:21mm;">
							<div class="styMainTitle" style="padding-top:2mm; display: block;">General Business Credit</div>
							<div class="styFST" style="padding-top:6mm;">
								Go to <a style="text-decoration:none;color:black;" href="http://www.irs.gov/Form3800" title="Link to irs.gov/Form3800">
									<i>www.irs.gov/Form3800</i>
								</a> for instructions and the latest information.
							</div>
							<div class="styFST" style="font-size:7pt;">
                 You must include all pages of Form 3800 with your return.
              </div>
						</div>
						<div class="styTYBox" style="width:41mm;height:21mm;">
							<div class="styOMB">
                OMB No. 1545-0895
              </div>
							<div class="styTaxYear" style="height:9mm;padding-top:0;">20<span class="styTYColor">24</span>
							</div>
							<div style="text-align:left;padding-left:3mm;">Attachment Sequence No. <span class="styBoldText">22</span>
							</div>
						</div>
					</div>
					<!-- End Form Number and Name section -->
					<!-- Begin Names and Identifying number section -->
					<div class="styBB" style="width:256mm;">
						<div class="styNameBox" style="width:190mm;font-size:7pt;font-weight:normal;">
              Name(s) shown on return<br/>
							<span>
								<xsl:call-template name="PopulateFilerName">
									<xsl:with-param name="TargetNode" select="$Form3800Data"/>
								</xsl:call-template>
							</span>
						</div>
						<div class="styEINBox" style="width:30mm;padding-left:2mm;font-size:7pt;font-weight:bold;">
              Identifying number<br/>
							<br/>
							<span style="font-size: 7pt; font-weight: normal;text-align:left; vertical-align: bottom;">
								<xsl:call-template name="PopulateFilerTIN">
									<xsl:with-param name="TargetNode" select="$Form3800Data"/>
								</xsl:call-template>
							</span>
						</div>
					</div>
					<!-- End Names and Identifying number section -->
					<div style="width:256mm;">
						<div class="styLNLeftNumBoxSD" style="padding-top:0.5mm;font-size:8pt;">A</div>
						<div style="width:245mm;height:10mm;font-size:8pt;padding-top:0.5mm;">
							<div style="height:12mm;width:245mm;">
								<b>Corporate Alternative Minimum Tax (CAMT) and Base Erosion Anti-Abuse Tax (BEAT). </b> Are you both (a) an “applicable
corporation” within the meaning of section 59(k)(1) for the CAMT, and (b) an “applicable taxpayer” within the meaning of
section 59A(e) for the BEAT? See instructions
							<span style="width:66mm;font-size:7pt;font-weight:normal;float:right; padding-top: 0.5px;">
									<span class="styDotLn" style="float:left;">...........</span>
									<span style="float:right;">
										<input type="checkbox" class="styCkboxNM" aria-label="Are you both an applicable corporation within the meaning of IRC 59(k)(1) for the CAMT and (b) an applicable taxpayer within the meaning of IRC 59A(e) for the BEAT? Inddicator Yes">
											<xsl:call-template name="PopulateYesCheckbox">
												<xsl:with-param name="TargetNode" select="$Form3800Data/CAMTAndBEATInd"/>
												<xsl:with-param name="BackupName" select="CAMTAndBEATInd"/>
											</xsl:call-template>
										</input>
										<span style="width:2px;"/>
										<label>
											<xsl:call-template name="PopulateLabelYes">
												<xsl:with-param name="TargetNode" select="$Form3800Data/CAMTAndBEATInd"/>
												<xsl:with-param name="BackupName" select="CAMTAndBEATInd"/>
											</xsl:call-template>
									Yes
								</label>
										<span style="width:10px;"/>
										<input type="checkbox" class="styCkboxNM" aria-label="Are you both an applicable corporation within the meaning of IRC 59(k)(1) for the CAMT and (b) an applicable taxpayer within the meaning of IRC 59A(e) for the BEAT? Inddicator No">
											<xsl:call-template name="PopulateNoCheckbox">
												<xsl:with-param name="TargetNode" select="$Form3800Data/CAMTAndBEATInd"/>
												<xsl:with-param name="BackupName" select="CAMTAndBEATInd"/>
											</xsl:call-template>
										</input>
										<span style="width:4px;"/>
										<label>
											<xsl:call-template name="PopulateLabelNo">
												<xsl:with-param name="TargetNode" select="$Form3800Data/CAMTAndBEATInd"/>
												<xsl:with-param name="BackupName" select="CAMTAndBEATInd"/>
											</xsl:call-template>
									No
								</label>
									</span>
								</span>
							</div>
						</div>
					</div>
					<!-- Begin Part I (Tentative Credit) Section -->
					<div class="styBB" style="width:256mm;height:8mm;border-top-width:2px;">
						<div class="styPartName" style="background-color:black;height:4mm;">Part I</div>
						<div class="styPartDesc">
							<span style="width:158mm;">Credits Not Allowed Against Tentative Minimum Tax (TMT)</span>
							<div style="width:158mm;font-weight:normal">Complete applicable portions of Parts III and IV before Parts I and II. See Instructions.</div>
						</div>
					</div>
					<!-- Part I, Line 1-->
					<div style="width:256mm;">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="styLNDesc" style="width:208mm; height:5mm;">
							<span style="float:left;">Credits not subject to the passive activity limit from Part III, line 2: combine column (e) with non-passive amounts from column
(f).</span>
							<!--Dotted Line-->
							<div class="styDotLn" style="float:right; margin-top: 4px;">..........</div>
						</div>
						<div class="styLNRightNumBox" style="padding-top:6px; height: 5mm;">1</div>
						<div class="styLNAmountBox" style="padding-top:6px; height: 5mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$Form3800Data/GeneralBusCrFromNnPssvActyAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part I, Line 2-->
					<div style="width:256mm;">
						<div class="styLNLeftNumBoxSD">2</div>
						<div class="styLNDesc" style="width:168mm; height: 7mm;">
							<span style="float:left; padding-right: 1.6px;">Credits subject to the passive activity limit. Combine from Part III, line 2, column (d), and passive amounts included on line 2, column (f); and Part IV, line 6, column (d)</span>
							<!--Dotted Line-->
							<div class="styDotLn" style="float:right;padding-right:1mm; margin-top: -9px;">............................</div>
						</div>
						<div class="styLNRightNumBox" id="styIRS3800new">2</div>
						<div class="styLNAmountBox" id="styIRS3800new">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$Form3800Data/CrSubjToPassiveActyLmtAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBoxNBB" style="height:7.5mm;background-color:lightgrey;"/>
						<div class="styLNAmountBoxNBB" style="height:7.5mm;"/>
					</div>
					<!-- Part I, Line 3-->
					<div style="width:256mm;">
						<!-- extra space -->
						<div class="styLNLeftNumBoxSD">3</div>
						<div class="styLNDesc" style="width:208mm;">
							<span style="float:left;">Enter the portion of line 2 allowed for 2024.</span>
							<!--Dotted Line-->
							<div class="styDotLn" style="float:right;">......................................</div>
						</div>
						<div class="styLNRightNumBox" style="width:8mm;">3</div>
						<div class="styLNAmountBox">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$Form3800Data/PssvActyForGenBusCrAllowedAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part I, Line 4-->
					<div style="width:256mm;">
						<!-- extra space -->
						<div class="styLNLeftNumBoxSD">4</div>
						<div class="styLNDesc" style="width:208mm;">
							<span style="float:left;">Enter the portion of Part IV, column (f), line 6, that is from carryforwards to 2024.   
									<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$Form3800Data/CYGeneralBusCrCarryforwardAmt"/>
								</xsl:call-template>
							</span>
							<!--Dotted Line-->
							<div class="styDotLn" style="float:right;">.........................</div>
						</div>
						<div class="styLNRightNumBox" style="width:8mm;">4</div>
						<div class="styLNAmountBox">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$Form3800Data/CYGeneralBusCrCarryforwardAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part I, Line 4 Checkbox -->
					<div style="width:256mm;">
						<div class="styLNLeftNumBoxSD"/>
						<div class="styLNDesc" style="width:208mm;">
							<span style="float:left;">
								Check this box if the carryforward was changed or revised from the original reported amount
								</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:left;padding-left:2mm;">.....................</span>
							<div style="width:6mm;float:right;">
								<input type="checkbox" class="styCkbox" style="padding-top:1mm;" aria-label="Indicates allowed carryforward amount was changed or revised from original amount">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$Form3800Data/CYGeneralBusCrCarryforwardAmt/@carryforwardChgdOrRevsInd"/>
										<xsl:with-param name="BackupName">
									Indicates allowed carryforward amount was changed or revised from original amount
								</xsl:with-param>
									</xsl:call-template>
								</input>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$Form3800Data/CYGeneralBusCrCarryforwardAmt/@carryforwardChgdOrRevsInd"/>
										<xsl:with-param name="BackupName">
										Indicates allowed carryforward amount was changed or revised from original amount
									</xsl:with-param>
									</xsl:call-template>
								</label>
							</div>
						</div>
						<div class="styLNRightNumBoxNBB" style="height:4.5mm;background-color:lightgrey;"/>
						<div class="styLNAmountBoxNBB" style="height:4.5mm;"/>
					</div>
					<!-- Part I, Line 5-->
					<div style="width:256mm;">
						<!-- extra space -->
						<div class="styLNLeftNumBoxSD">5</div>
						<div class="styLNDesc" style="width:208mm;">
							<span style="float:left;">Enter the portion of Part IV, column (f), line 6, that is from carrybacks from 2025. </span>
							<!--Dotted Line-->
							<div class="styDotLn" style="float:right;">..........................</div>
						</div>
						<div class="styLNRightNumBox" style="width:8mm;">5</div>
						<div class="styLNAmountBox">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$Form3800Data/CarryBackGeneralBusinessCrAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part I, Line 6-->
					<div style="width:256mm;">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="styLNDesc" style="width:208mm;">
							<!-- Revisit: Changing year 2002 to 2003 -->
							<!--Passive activity credits allowed for 2002-->
							<span style="float:left;">Add lines 1, 3, 4, and 5</span>
							<!--Dotted Line-->
							<div class="styDotLn" style="float:right;">............................................</div>
						</div>
						<div class="styLNRightNumBoxNBB" style="height:4mm;">6</div>
						<div class="styLNAmountBoxNBB" style="height:4mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$Form3800Data/CYCreditsNotAllwAgainstTMTAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!--  Begin Part II Title -->
					<div class="styBB" style="width:256mm; border-top-width:2px;">
						<div class="styPartName" style="background-color:black;height:4mm;">Part II</div>
						<div class="styPartDesc">
							<span style="width:8px;"/>Figuring Credit Allowed After Limitations
            </div>
					</div>
					<!-- Part II Second Heading -->
					<div class="styBB" style="width:256mm;border-bottom-width:1px;">
						<div class="styPartDesc" style="width:256mm;padding-left:0mm;font-weight:normal;height:4mm;">
							<b>Section A - Figuring Credit Allowed After Section 38(c)(1) Limitation Based on Amount of Tax</b>
						</div>
					</div>
					<div class="styGenericDiv" style="width:256mm;clear:all;height:auto;">
						<!-- Part II, Line 7 -->
						<div style="width:256mm">
							<div class="styLNLeftNumBoxSD">7</div>
							<div class="styLNDesc" style="width:156.9mm;">
		       Regular tax before credits:
								<ul style="padding-left:0;margin-left:4mm;margin-top:0;">
									<li style="padding-top:1mm; width: 180mm;"> Individuals.  Enter the sum of the amounts from Form 1040, 1040-SR, or 1040-NR, line 
									16; and Schedule 2 (Form 1040), line 1z.
									</li>
									<li style="padding-top:1mm; width: 180mm;"> Corporations. Enter the amount from Form 1120, Schedule J, Part I, line 2 (excluding the base erosion minimum tax entered on line 1f); or the 
									applicable line of your return.
									</li>
									<li style="padding-top:1mm; width: 180mm;"> Estates and trusts. Enter the sum of the amounts from Form 1041, Schedule G, lines 1a, 1b and 1d, plus any Form 8978 amount included on line 1e; or the amount from the 
									applicable line of your return.
									</li>
								</ul>
							</div>
							<div class="styLNDesc" style="width:5mm;padding-top:4mm; margin-left: 105px;">
								<img src="{$ImagePath}/3800_Bracket_Lger.gif" height="67mm;" alt="Curly Bracket Image"/>
							</div>
							<span class="styDotLn" style="height:21mm;width:18.2mm;padding-top:14mm;">.....</span>
							<div class="styLNRightNumBox" style="height:13mm;border-bottom-width:0px;background-color:lightgrey;padding-top:5mm;"/>
							<div class="styLNAmountBox" style="height:13mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:5mm;"/>
							<div class="styLNRightNumBox" style="height:4.5mm;">7</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/RegularTaxBeforeCreditsAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="height:11mm;border-bottom-width:0px;background-color:lightgrey;padding-top:5mm;"/>
							<div class="styLNAmountBox" style="height:11mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:5mm;"/>
						</div>
						<!-- Part II, Line 8 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBoxSD">8</div>
							<div class="styLNDesc" style="width:156.9mm;height:3mm;">
                 Alternative minimum tax: 
								<ul style="padding-left:0;margin-left:4mm;margin-top:0;">
									<li style="padding-top:1mm;">
										Individuals. Enter the amount from Form 6251, line 11.
									</li>
									<li style="padding-top:1mm;">
										Corporations. Enter the amount from Form 4626, Part II, line 13.
									</li>
									<li style="padding-top:1mm;">
										Estates and trusts. Enter the amount from Schedule I (Form 1041), line 54.
									</li>
								</ul>
							</div>
							<div class="styLNDesc" style="width:5mm; margin-left: 101px; padding-left: 5px">
								<img src="{$ImagePath}/3800_Bracket_Sm.gif" height="50mm" alt="Curly Bracket Image"/>
							</div>
							<span class="styDotLn" style="height:15mm;width:19.2mm;padding-top:5mm;">.....</span>
							<div class="styLNRightNumBox" style="height:5mm;border-bottom-width:0px;background-color:lightgrey;padding-top:1mm;"/>
							<div class="styLNAmountBox" style="height:5mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:1mm;"/>
							<div class="styLNRightNumBox" style="height:4.5mm;">8</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AlternativeMinimumTaxAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="height:8mm;border-bottom-width:0px;background-color:lightgrey;padding-top:1mm;"/>
							<div class="styLNAmountBox" style="height:8mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:1mm;"/>
						</div>
						<!-- Part II, Line 9 -->
						<div style="width:256mm;clear:none;height:4mm;">
							<div class="styLNLeftNumBoxSD">9</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Add lines 7 and 8 </span>
								<!--Dotted Line-->
								<div class="styDotLn" style="float:right;">..............................................</div>
							</div>
							<div class="styLNRightNumBox">9</div>
							<div class="styLNAmountBox">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AdjustedRegTaxBeforeCreditAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 10a -->
						<!-- The following form element does not have a matching element in the schema -->
						<div style="width:256mm;">
							<!--     Extra Space   -->
							<div class="styLNLeftNumBox" style="height:3mm;"/>
							<div class="styLNDesc" style="width:175.8mm;height:3mm;"/>
							<div class="styLNAmountBox" style="height:3mm;border-left-width:0px;border-bottom-width:0px;border-left-width:0px;"/>
							<div class="styLNRightNumBox" style="height:3mm;border-bottom-width:0px;padding-top:.5mm;background-color:lightgray;"/>
							<div class="styLNAmountBox" style="height:3mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:.5mm;"/>
							<!-- extra space -->
						</div>
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">10a</div>
							<div class="styLNDesc" style="width:167.8mm;">
								<span style="float:left;">Foreign tax credit </span>
								<div class="styDotLn" style="float:right;">....................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">10a</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/ForeignTaxCreditAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:4.5mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:4.5mm;"/>
						</div>
						<!-- Part II, Line 10b -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="padding-left:4.5mm">b</div>
							<div class="styLNDesc" style="width:167.8mm;">
								<span style="float:left;">Certain allowable credits (see instructions) </span>
								<!--Dotted Line-->
								<div class="styDotLn" style="float:right;">............................</div>
							</div>
							<div class="styLNRightNumBox">10b</div>
							<div class="styLNAmountBox">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/CertainAllowableCreditsAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:4.5mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:4.5mm;"/>
						</div>
						<!-- Part II, Line 10c -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="padding-left:4.5mm;">c</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Add lines 10a and 10b </span>
								<!--Dotted Line-->
								<div class="styDotLn" style="float:right;">.............................................</div>
							</div>
							<div class="styLNRightNumBox">10c</div>
							<div class="styLNAmountBox">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/TotalTaxCreditsAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 11 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="height:6mm;padding-top:3mm;">11</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="height:6mm;padding-top:2.5mm;">
									<b>Net income tax.</b> Subtract line 10c from line 9. If zero, skip lines 12 through 15 and enter -0- on line 16</span>
								<!--Dotted Line-->
								<div class="styDotLn" style="float:right; margin-top: 10px;">...................</div>
							</div>
							<div class="styLNRightNumBox" style="height:6mm;padding-top:2.8mm;">11</div>
							<div class="styLNAmountBox" style="height:6mm;padding-top:2.8mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/NetIncomeTaxAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="height:4mm;"/>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="height:4mm;"/>
								<!--Dotted Line-->
								<div class="styDotLn" style="float:right;"/>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:4mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:4mm;"/>
						</div>
						<!-- extra space -->
						<!-- Part II, Line 12 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">12</div>
							<div class="styLNDesc" style="width:167.8mm;">
								<span style="float:left;">
									<b> Net regular tax.</b> Subtract line 10c from line 7.  If zero or less, enter -0- </span>
								<div class="styDotLn" style="float:right;">...................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">12</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/NetRegularTaxAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:4.5mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:4.5mm;"/>
						</div>
						<!-- Part II, Line 13 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="height:6mm;">13</div>
							<div class="styLNDesc" style="height:6mm;width:167.8mm;">
								Enter 25% (0.25) of the excess, if any, of line 12 (line 11 for corporations) 
								over $25,000. See instructions
								<span class="styDotLn" style="float:right;">........</span>
							</div>
							<div class="styLNRightNumBox" style="height:6mm;">
								<div style="background-color: lightgrey;height:6mm;"/>
								<div style="height:6mm; padding-right: 0.5mm;">13</div>
							</div>
							<div class="styLNAmountBox" style="height:6mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/ExcessNetRegularTaxAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:6mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:6mm;"/>
						</div>
						<!-- Part II, Line 14 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">14</div>
							<div class="styLNDesc" style="width:154.6mm;">
             Tentative minimum tax: 
								<ul style="padding-left:0;margin-left:4mm;margin-top:0;">
									<li style="padding-top:1mm;">
										Individuals. Enter the amount from Form 6251, line 9.
									</li>
									<li style="padding-top:1mm;">
										Corporations. Enter -0-.
									</li>
									<li style="padding-top:1mm;">
										Estates and trusts. Enter the amount from Schedule I (Form 1041), line 52.
									</li>
								</ul>
							</div>
							<div class="styLNDesc" style="width:5mm;">
								<img src="{$ImagePath}/3800_Bracket_Sm.gif" style="padding-top:4mm;" height="59mm" alt="Curly Bracket Image"/>
							</div>
							<span class="styDotLn" style="width:8.2mm;height:14mm;padding-top:9mm;">..</span>
							<div class="styLNRightNumBox" style="height:13mm;padding-top:9mm;">
								14
							</div>
							<div class="styLNAmountBox" style="height:13mm;padding-top:9mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/TentativeMinimumTaxAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:17mm;background-color:lightgrey"/>
							<div class="styLNAmountBoxNBB" style="height:17mm;"/>
						</div>
						<!-- Part II, Line 15.-->
						<div style="width:256mm;height:7mm;">
							<div class="styLNLeftNumBox" style="padding-top:3mm;">15</div>
							<div class="styLNDesc" style="width:207.8mm;padding-top:3mm;">
								<span style="float:left;">Enter the greater of line 13 or line 14 </span>
								<div class="styDotLn" style="float:right;">........................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:7mm;padding-top:3mm;">15</div>
							<div class="styLNAmountBox" style="height:7mm;padding-top:3mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AdjustedExcessNetRegularTaxAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 16 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">16</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Subtract line 15 from line 11. If zero or less, enter -0- </span>
								<div class="styDotLn" style="float:right;">...................................</div>
							</div>
							<div class="styLNRightNumBox">16</div>
							<div class="styLNAmountBox">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AdjustedNetIncomeTaxAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 17 -->
						<div style="width:256mm; height: 6mm;">
							<div class="styLNLeftNumBox">17</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;" >Enter the <b>smaller</b> of line 6 or line 16. This is the amount of your credit allowed after the limitation of section 38(c)(1)
								<!--Pen and ink image -->
									<xsl:call-template name="LinkToLeftoverDataTableInline">
										<xsl:with-param name="Desc">Section 41(G) Indicator Code</xsl:with-param>
										<xsl:with-param name="TargetNode" select="$Form3800Data/SmllrCYNotAllwTMTOrTotAdjAmt/@section383Or384IndicatorCd"/>
									</xsl:call-template>
								</span>
								<div class="styDotLn" style="float:right; margin-top: 6px;">..............</div>
							</div>
							<div class="styLNRightNumBox" style="height:6mm; padding-top: 2mm;">17</div>
							<div class="styLNAmountBox" style="height:6mm; padding-top: 2mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/SmllrCYNotAllwTMTOrTotAdjAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 17 -->
						<div class="styBB" style="width:256mm;border-bottom-width:2px;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm; margin-top: -7px;">
								<span class="styBoldText">C corporations:</span> See the line 17 instructions if there has been an ownership change, acquisition, or reorganization. 
						</div>
							<div class="styLNRightNumBoxNBB" style="height:5mm;padding-top:0mm;width:8mm;background-color:lightgray;"/>
							<div class="styLNAmountBoxNBB" style="height:5mm;padding-top:0mm;width:32mm; background-color:lightgray;"/>
						</div>
					</div>
					<!--Page 1 Footer -->
					<div class="styStdDiv pageEnd" style="width: 256mm;">
						<span style="font-weight:bold;">For Paperwork Reduction Act Notice, see separate instructions.</span>
						<span style="margin-left:24mm;">Cat. No. 12392F</span>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- Page 2 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">2</span>
						</div>
					</div>
					<!--  Begin Part II Title -->
					<div class="styBB" style="width:256mm;border-top-width:2px;">
						<div class="styPartName" style="background-color:black;height:4mm;">Part II</div>
						<div class="styPartDesc">
							<span style="width:8px;"/>Figuring Credit Allowed After Limitations <span style="font-weight:normal;">
								<i>(Continued)</i>
							</span>
						</div>
					</div>
					<!-- Part II Second Heading -->
					<div class="styBB" style="width:256mm;border-bottom-width:1px;">
						<div class="styPartDesc" style="width:256mm;padding-left:0mm;font-weight:normal;height:4mm;">
							<b>Section B - Figuring Section 38(c)(2) Empowerment Zone and Community Renewal Employment Credit Allowed</b>.</div>
					</div>
					<!--Part II Continue, Note Line -->
					<div class="styBB" style="width:256mm;border-bottom-width:1px;">
						<div class="styPartDesc" style="width:256mm;padding-left:0mm;font-weight:normal;height:4mm;">
							<b>Note:</b> If you are not required to report any amounts on lines 22 or 24 below, skip lines 18 through 25 and enter -0- on line 26.</div>

					</div>
					<div class="styGenericDiv" style="width:256mm;clear:all;height:auto;">
						<!-- Part II, Line 18 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">18</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Multiply line 14 by 75% (0.75). See instructions </span>
								<div class="styDotLn" style="float:right;">.....................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">18</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/TentativeMinimunTaxTimesPctAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 19 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">19</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Enter the greater of line 13 or line 18 </span>
								<div class="styDotLn" style="float:right;">........................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">19</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/GreaterExcessOrTimesPctAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 20 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">20</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Subtract line 19 from line 11. If zero or less, enter -0- </span>
								<div class="styDotLn" style="float:right;">..................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">20</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/NetIncmTaxLessGreaterExcessAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 21 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">21</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Subtract line 17 from line 20. If zero or less, enter -0- </span>
								<div class="styDotLn" style="float:right;">..................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">21</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/SubSmllrFromNetLessGreaterAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 22 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">22</div>
							<div class="styLNDesc" style="width:207.8mm; height: 6mm;">
								<span style="float:left;">
									Combine the amounts from line 3 of Part III, column (e), with the amount from line 3 of Part IV, column (f).
								</span>
								<div class="styDotLn" style="float:right;">.................</div>
							</div>
							<div class="styLNRightNumBox" style="height:6mm;">22</div>
							<div class="styLNAmountBox" style="height:6mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/TotEmpwrZoneGenBusCreditsAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 23 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="height:1mm;"/>
							<div class="styLNDesc" style="width:175.8mm;height:1mm;"/>
							<div class="styLNAmountBox" style="height:3mm;border-left-width:0px;border-bottom-width:0px;border-left-width:0px;"/>
							<div class="styLNRightNumBox" style="height:3mm;border-bottom-width:0px;padding-top:.5mm;background-color:lightgrey;width:8mm"/>
							<div class="styLNAmountBox" style="height:3mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:.5mm;"/>
						</div>
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">23</div>
							<div class="styLNDesc" style="width:167.8mm; height: 5.5mm;">
								<span style="float:left;">
									Passive activity credit from line 3 of Part III, column (d) plus the amount from line 3 of Part IV, column (d)
								</span>
								<div class="styDotLn" style="float:right; margin-top: 3px;">........</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm; padding-top: 2.7px">23</div>
							<div class="styLNAmountBox" style="height: 4.5mm; padding-top: 2.7px">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/GBCFromPssvActyAllPartsAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:5mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:5mm;"/>
						</div>
						<!-- Part II, Line 24 -->
						<!--     Extra Space   -->
						<div style="width:256mm; margin-top: -3px;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">24</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Enter the applicable passive activity credit allowed for 2024. See instructions</span>
								<div class="styDotLn" style="float:right;">...........................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">24</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/PassiveActyAllowedForTYAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 25 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">25</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Add lines 22 and 24</span>
								<div class="styDotLn" style="float:right;">.............................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">25</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/TotalPassiveActivityCreditAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 26-->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">26</div>
							<div class="styLNDesc" style="width:207.8mm;">
								Empowerment zone and renewal community employment credit allowed. Enter the smaller of line 21 or line 25
								<div class="styDotLn" style="float:right;">.................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm; border-bottom-width: 0;">26</div>
							<div class="styLNAmountBox" style="height:4.5mm; border-bottom-width: 0;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/EmpwrZoneAndComEmploymentCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
					<!-- Part II Section C -->
					<div class="styBB" style="width:256mm;border-bottom-width:1px; border-top-width: 2px; padding: 2px;">
						<div class="styPartDesc" style="width:256mm;padding-left:0mm;font-weight:normal;height:4mm;">
							<b>Section C - Figuring the Specified Credit Amount Allowed Under Section 38(c)(4)</b></div>
					</div>
						<!-- Part II, Line 27 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">27</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Subtract line 13 from line 11. If zero or less, enter -0- </span>
								<div class="styDotLn" style="float:right;">..................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">27</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/NetIncomeTaxLessPctExcessAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 28 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">28</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Add lines 17 and 26 </span>
								<div class="styDotLn" style="float:right;">.............................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">28</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/SumSmllrEmpwrZnEmplmnCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 29 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">29</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Subtract line 28 from line 27. If zero or less, enter -0- </span>
								<div class="styDotLn" style="float:right;">..................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">29</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/NetSmllrAndEmpwrZnEmplmnCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 30 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">30</div>
							<div class="styLNDesc" style="width:207.8mm; height: 5mm;">
								<span style="float:left;">Enter the general business credit from line 5 of Part III: combine column (e) with non-passive amounts in column (f). See instructions</span>
								<div class="styDotLn" style="float:right; margin-top: 3px;">.........</div>
							</div>
							<div class="styLNRightNumBox" id="styIRS3800II">30</div>
							<div class="styLNAmountBox" id="styIRS3800II">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AllwGenBusCrFromNonPssvActyAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 31 -->
						<!--     Extra Space   -->
						<!-- Part II, Line 31-->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-bottom-width:0px;background-color:lightgrey;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">31</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Reserved</span>
								<span class="styDotLn" style="float:right;">.................................................</span>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">31</div>
							<div class="styLNAmountBox" style="height:4.5mm;background-color:lightgrey;"/>
						</div>
						<!-- Part II, Line 32 -->
						<!-- The following form element does not have a matching element in the schema -->
						<div style="width:256mm;">
							<!--     Extra Space   -->
							<div class="styLNLeftNumBox" style="height:1mm;"/>
							<div class="styLNDesc" style="width:175.8mm;height:1mm;"/>
							<div class="styLNAmountBox" style="height:3mm;border-left-width:0px;border-bottom-width:0px;border-left-width:0px;"/>
							<div class="styLNRightNumBox" style="height:3mm;border-bottom-width:0px;padding-top:.5mm;background-color:lightgrey;width:8mm"/>
							<div class="styLNAmountBox" style="height:3mm;border-left-width:0px;border-bottom-width:0px;border-left-width:1px;padding-top:.5mm;"/>
							<!-- extra space -->
						</div>
						<div style="width:256mm;">
							<div class="styLNLeftNumBox" style="padding-top:1mm">32</div>
							<div class="styLNDesc" style="width:167.8mm;padding-top:1mm;">
								<span style="float:left;">Passive activity credits from line 5 of Part III: combine column (d) with passive amounts in column (f). See instructions</span>
								<span class="styDotLn" style="float:right; margin-top: 3px;">....</span>
							</div>
							<div class="styLNRightNumBox" style="height:5.5mm; padding-top: 1.5mm;">32</div>
							<div class="styLNAmountBox" style="height:5.5mm; padding-top: 1.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/GenBusEligSmllBusPssvActyCrAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:5.5mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:5.5mm;"/>
						</div>
						<!-- Part II, Line 33 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;background-color:lightgrey;"/>
							<div class="styLNAmountBox" style="border-bottom-width:0px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">33</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Enter the applicable passive activity credits allowed for 2024. See instructions</span>
								<div class="styDotLn" style="float:right;">...........................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">33</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/OtherSpecifiedAllwGenBusCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 34 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">34</div>
							<div class="styLNDesc" style="width:207.8mm;">
								Carryforward of business credit to 2024. Enter the amount of carryforwards from line 7 of Part IV, column (g).
								<div class="styDotLn" style="float:right; margin-top: 3px;">....</div>
								<span style="float: right; width: 53mm;">See instructions for statement to attach
								<!-- Push Pin image -->
									<xsl:call-template name="SetFormLinkInline">
										<xsl:with-param name="TargetNode" select="$Form3800Data/AllwGenAndEligSmllBusCfwdCrAmt"/>
									</xsl:call-template>
								</span>
							</div>
							<div class="styLNRightNumBox" style="height:5.5mm;padding-top:1mm;">34</div>
							<div class="styLNAmountBox" style="height:5.5mm;padding-top:1mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AllwGenAndEligSmllBusCfwdCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 34 Checkbox -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBoxSD"/>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">
								Check this box if the carryforward was changed or revised from the original reported amount
								</span>
								<!--Dotted Line-->
								<span class="styDotLn" style="float:left;padding-left:2.5mm; padding-top: 1px">.....................</span>
								<div style="width:5mm;float:right; margin-top: -3px;">
									<input type="checkbox" class="styCkbox" aria-label="Indicates allowed carryforward amount was changed or revised from original amount">
										<xsl:call-template name="PopulateCheckbox">
											<xsl:with-param name="TargetNode" select="$Form3800Data/AllwGenAndEligSmllBusCfwdCrAmt/@carryforwardChgdOrRevsInd"/>
											<xsl:with-param name="BackupName">
									Indicates allowed carryforward amount was changed or revised from original amount
								</xsl:with-param>
										</xsl:call-template>
									</input>
									<label>
										<xsl:call-template name="PopulateLabel">
											<xsl:with-param name="TargetNode" select="$Form3800Data/AllwGenAndEligSmllBusCfwdCrAmt/@carryforwardChgdOrRevsInd"/>
											<xsl:with-param name="BackupName">
										Indicates allowed carryforward amount was changed or revised from original amount
									</xsl:with-param>
										</xsl:call-template>
									</label>
								</div>
							</div>
							<div class="styLNRightNumBoxNBB" style="height:4.5mm;background-color:lightgrey;"/>
							<div class="styLNAmountBoxNBB" style="height:4.5mm;"/>
						</div>
						<!-- Part II, Line 35-->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;background-color:lightgrey;"/>
							<div class="styLNAmountBox" style="border-bottom-width:0px;"/>
						</div>
						<!-- extra space -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">35</div>
							<div class="styLNDesc" style="width:207.8mm; padding-right: 0.5px;">
								<div class="styDotLn" style="float:right;">.............</div>
								Carryback of business credit from 2025. Enter the amount of carrybacks from line 7 of Part IV, column (g). See instructions

							</div>
							<div class="styLNRightNumBox">35</div>
							<div class="styLNAmountBox">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/AllwGenAndEligSmllBusCybkCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 36 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-left-width:0px;border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">36</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Add lines 30, 33, 34, and 35</span>
								<div class="styDotLn" style="float:right;">..........................................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm;">36</div>
							<div class="styLNAmountBox" style="height:4.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/TotAllwGenAndEligSmllBusCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part II, Line 37 -->
						<!--     Extra Space   -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<!-- extra space -->
						<!-- check here -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">37</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="float:left;">Enter the <b>smaller</b> of line 29 or line 36. This is the amount allowed for specified credits </span>
								<div class="styDotLn" style="float:right;">........................</div>
							</div>
							<div class="styLNRightNumBox" style="height:4.5mm; border-bottom-width: 0;">37</div>
							<div class="styLNAmountBox" style="height:4.5mm; border-bottom-width: 0;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/SmllrGenBusCrOrTotGenEligCrAmt"/>
								</xsl:call-template>
							</div>
						</div>
						
					<!-- Part II Section D -->
					<div class="styBB" style="width:256mm;border-bottom-width:1px; border-top-width: 2px; padding: 2px;">
						<div class="styPartDesc" style="width:256mm;padding-left:0mm;font-weight:normal;height:4mm;">
							<b>Section D - Credits Allowed After Limitations</b></div>
					</div>
						<!-- Part II, Line 38 -->
						<div style="width:256mm;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:207.8mm;"/>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;"/>
							<div class="styLNAmountBox" style="border-bottom-width:0px;border-left-width:1px;"/>
						</div>
						<div style="width:256mm;">
							<div class="styLNLeftNumBox">38</div>
							<div class="styLNDesc" style="width:207.8mm;">
								<span style="styBoldText">
									<b>Credit allowed for the current year.</b>
								</span> Add lines 28 and 37. 
                 <!-- Push Pin image -->
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$Form3800Data/CurrentYearCreditAllowedAmt"/>
								</xsl:call-template>
								<br/>
								Report the amount from line 38 (if smaller than the sum of Part I, line 6, and Part II, lines 25 and 36; see
								instructions) as indicated below or on the applicable line of your return.
							</div>
							<div class="styLNRightNumBox" style="height:10.9mm;border-bottom-width:0px;padding-top:1.5mm;"/>
							<div class="styLNAmountBox" style="height:10.9mm;border-bottom-width:0px;border-left-width:1px;padding-top:1.5mm;"/>
						</div>
						<div class="styBB" style="width:256mm;border-bottom-width:2px;">
							<div class="styLNLeftNumBox"/>
							<div class="styLNDesc" style="width:143.8mm;">
								<ul style="padding-left:0;margin-left:4mm;margin-top:0;">
									<li>Individuals. Schedule 3 (Form 1040),  line 6a.</li>
									<li>Corporations. Form 1120, Schedule J, Part I, line 5c.</li>
									<li>Estates and trusts. Form 1041, Schedule G, line 2b.</li>
								</ul>
							</div>
							<div class="styLNDesc" style="width:5mm;">
								<img src="{$ImagePath}/3800_Bracket_Sm.gif" height="40mm" alt="Curly Bracket Image"/>
							</div>
							<span class="styDotLn" style="width:59mm;height:12mm;padding-top:4mm;">...............</span>
							<div class="styLNRightNumBox" style="height:8.5mm;padding-top:4mm;">38</div>
							<div class="styLNAmountBox" style="height:8.5mm;padding-top:4mm;border-left-width:1px;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$Form3800Data/CurrentYearCreditAllowedAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="border-bottom:0;background-color:lightgrey;"/>
							<div class="styLNAmountBox" style="border-bottom:0;background-color:lightgrey;"/>
						</div>
						<!--Page 2 Footer -->
					</div>
					<div class="styStdDiv pageEnd" style="width: 256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part III Table 1 START ============================================= -->
					<!-- =============================================================================================================== -->
					<!-- Page 3 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">3</span>
						</div>
					</div>
					<div class="styBB" style="width:256mm;border-top-width:2px;">
						<div class="styGenericDiv" style="width:256mm;height:8mm;">
							<div class="styPartName" style="width:15mm;">Part III</div>
							<div class="styPartDesc" style="padding-left:3mm;width:235mm;font-weight:normal;">
								<b>Current Year General Business Credits (GBCs) </b> 
							(see instructions). If there is more than one number applicable for column (b) or (c) for a line in Part III, enter the number of such items in column (a), complete Part V, and see instructions for what to report on that line in Part III.
							</div>
						</div>
					</div>
					<div class="styTableContainerLandscape" style="height:auto;display:block;border-bottom-width:1px;" id="PartIIITable1Ctn">
						<table class="styTable" cellspacing="0" name="PartIIITable1" id="PartIIITable1">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartIIITableCellHeader" style="width:8mm;border-bottom-width:0mm;border-right-width:0mm;"/>
									<th class="styIRS3800PartIIITableCellHeader" scope="col" style="width:50mm;">
										<br/>Current year credits from:
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col" style="width:30mm;">
										<b>(a)</b>
										<br/>No. of items
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(b)</b>
										<br/> Elective payment or transferor registration number
									</th>
									<th class="styIRS3800PartIIITableCellHeader" style="width:8mm;">
										<b>(c)</b>
										<br/> Pass-through or transferor credit entity EIN
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(d)</b>
										<br/> Credits subject to the passive activity limit, before application of the limit
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(e)</b>
										<br/> Credits not subject to the passive activity limits
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(f)</b>
										<br/> Credit transfer election amount (enter amounts transferred out as a negative amount)
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(g)</b>
										<br/> Combine columns (e) and (f) with the credit from column (d) allowed after the passive activity limit
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(h)</b>
										<br/> Gross elective payment election (EPE) amount
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(i)</b>
										<br/> Amount of column (g) applied against tax in Part II
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col" style="border-right-width:0px;">
										<b>(j)</b>
										<br/> Net EPE amount. Enter the smaller of column (h) <b>or</b> column (g) minus column (i)
									</th>
								</tr>
							</thead>
							<tbody>
								<!-- Part III, line 1a -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form3468PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">1a</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part II</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1b -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form7207CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">b</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7207</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 1c -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form6765CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">c</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6765</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1d -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form3468PartIIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">d</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part III</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, line 1e -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8826CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">e</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8826</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1f -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8835PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">f</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8835, Part II</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1g -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form7210CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">g</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7210</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, line 1h -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8820CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">h</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8820</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1i -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8874CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">i</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8874</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1j -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8881PartICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">j</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8881, Part I</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1k -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8882CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">k</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8882</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1l -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8864CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">l</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8864 (diesel)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1m -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8896CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">m</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8896</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1n -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8906CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">n</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8906</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, line 1o -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form3468PartIVCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">o</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part IV</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, line 1p -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8908CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">p</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8908</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1q -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form7218PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">q</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7218, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"></xsl:with-param>
									<xsl:with-param name="ColC"></xsl:with-param>
									<xsl:with-param name="ColD"></xsl:with-param>
									<xsl:with-param name="ColE"></xsl:with-param>
									<xsl:with-param name="ColF"></xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH"></xsl:with-param>
									<xsl:with-param name="ColI"></xsl:with-param>
									<xsl:with-param name="ColJ"></xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1r -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Reserved1rCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">r</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1s -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8911PartICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">s</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8911, Part I</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 1t -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8830CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">t</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8830</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1u -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form7213PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">u</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7213, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 1v -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form3468PartVCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">v</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part V</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 1w -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8932CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">w</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8932</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1x -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8933CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">x</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8933</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 1y -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8936PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">y</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8936, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1z -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">z</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1aa -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8936PartVCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">aa</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8936, Part V</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 1 bb -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8904CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">bb</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8904</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1cc  -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form7213PartICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">cc</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7213, Part I</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1dd -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8881PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">dd</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8881, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1ee -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8881PartIIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">ee</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8881, Part III</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1ff -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8864SAFCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">ff</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8864, Line 8</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1gg -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form7211PartIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">gg</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7211, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"></xsl:with-param>
									<xsl:with-param name="ColC"></xsl:with-param>
									<xsl:with-param name="ColD"></xsl:with-param>
									<xsl:with-param name="ColE"></xsl:with-param>
									<xsl:with-param name="ColF"></xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH"></xsl:with-param>
									<xsl:with-param name="ColI"></xsl:with-param>
									<xsl:with-param name="ColJ"></xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1hh -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Reserved1hhCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">hh</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1ii -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Reserved1iiCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">ii</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 1zz -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/GenBusCYOtherCreditsGrp"/>
									<xsl:with-param name="RowNumber">zz</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Other credits</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 2 -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/GenBusCYCreditsSubTotGrp"/>
									<xsl:with-param name="RowNumber">2</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Add lines 1a through 1zz</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
							</tbody>
						</table>
					</div>
					<!-- Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part III Table 1 END =============================================== -->
					<!-- =============================================================================================================== -->
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part III Table 2 START ============================================= -->
					<!-- =============================================================================================================== -->
					<!-- Page 4 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">4</span>
						</div>
					</div>
					<div class="styBB" style="width:256mm;border-top-width:2px;">
						<div class="styGenericDiv" style="width:256mm;height:8mm;">
							<div class="styPartName" style="width:15mm;">Part III</div>
							<div class="styPartDesc" style="padding-left:3mm;width:235mm;font-weight:normal;">
								<b>Current Year General Business Credits (GBCs) </b> 
							(see instructions). If there is more than one number applicable for column (b) or (c) for a line in Part III, enter the number of such items in column (a), complete Part V, and see instructions for what to report on that line in Part III. <i>(continued)</i>
							</div>
						</div>
					</div>
					<div class="styTableContainerLandscape" style="height:auto;display:block;" id="PartIIITable2Ctn">
						<table class="styTable" cellspacing="0" name="PartIIITable2" id="PartIIITable2">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartIIITableCellHeader" style="width:8mm;border-bottom-width:0mm;border-right-width:0mm;"/>
									<th class="styIRS3800PartIIITableCellHeader" scope="col" style="width:80mm;">
										<br/>Current year credits from:
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col" style="width:30mm;">
										<b>(a)</b>
										<br/>No. of items
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(b)</b>
										<br/> Elective payment or transferor registration number
									</th>
									<th class="styIRS3800PartIIITableCellHeader" style="width:8mm;">
										<b>(c)</b>
										<br/> Pass-through or transferor credit entity EIN
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(d)</b>
										<br/> Credits subject to the passive activity limit, before application of the limit
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(e)</b>
										<br/> Credits not subject to the passive activity limits
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(f)</b>
										<br/> Credit transfer election amount (enter amounts transferred out as a negative amount)
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(g)</b>
										<br/> Combine columns (e) and (f) with the credit from column (d) allowed after the passive activity limit
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(h)</b>
										<br/> Gross elective payment election (EPE) amount
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col">
										<b>(i)</b>
										<br/> Amount of column (g) applied against tax in Part II
									</th>
									<th class="styIRS3800PartIIITableCellHeader" scope="col" style="border-right-width:0px;">
										<b>(j)</b>
										<br/> Net EPE amount. Enter the smaller of column (h) <b>or</b> column (g) minus column (i)
									</th>
								</tr>
							</thead>
							<tbody>
								<!-- Part III, Line 3 -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8844CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">3</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8844</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4 -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">4</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Specified credits:</xsl:with-param>
									<xsl:with-param name="ColA">nofill</xsl:with-param>
									<xsl:with-param name="ColB">nofill</xsl:with-param>
									<xsl:with-param name="ColC">nofill</xsl:with-param>
									<xsl:with-param name="ColD">nofill</xsl:with-param>
									<xsl:with-param name="ColE">nofill</xsl:with-param>
									<xsl:with-param name="ColF">nofill</xsl:with-param>
									<xsl:with-param name="ColG">nofill</xsl:with-param>
									<xsl:with-param name="ColH">nofill</xsl:with-param>
									<xsl:with-param name="ColI">nofill</xsl:with-param>
									<xsl:with-param name="ColJ">nofill</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4a -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form3468PartVICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">a</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part VI</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 4b -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form5884CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">b</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4c -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form6478CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">c</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6478</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III  Line 4d -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8586CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">d</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8586</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4e -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8835PartIICYSpcfdCreditsGrp"/>
									<xsl:with-param name="RowNumber">e</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8835, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 4f -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8846CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">f</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8846</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4g -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8900CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">g</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8900</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4h -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8941CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">h</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8941</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4i -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form6765ESBCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">i</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6765 (ESB)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4j -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form8994CYCreditsGrp"/>
									<xsl:with-param name="RowNumber">j</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8994</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4k -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Form3468PartVIICYCreditsGrp"/>
									<xsl:with-param name="RowNumber">k</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part VII</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4l -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Reserved4lCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">l</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4m -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Reserved4mCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">m</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 4z -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/GenBusOtherSpecifiedCYCrGrp"/>
									<xsl:with-param name="RowNumber">z</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Other specified credits</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part III, Line 5 -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/GenBusCYCreditsSubTot2Grp"/>
									<xsl:with-param name="RowNumber">5</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Add lines 4a-4z</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
								<!-- Part III, Line 6  -->
								<xsl:call-template name="Part3TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/TotGenBusCYCreditAmtGrp"/>
									<xsl:with-param name="RowNumber">6</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Add lines 2, 3, and 5</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
									<xsl:with-param name="ColJ"/>
								</xsl:call-template>
							</tbody>
						</table>
					</div>
					<!--Page 3 Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part III Table 2 END =============================================== -->
					<!-- =============================================================================================================== -->
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part IV Table 1 START ============================================== -->
					<!-- =============================================================================================================== -->
					<!-- Page 5 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">5</span>
						</div>
					</div>
					<div class="styBB" style="width:256mm;border-top-width:2px;border-bottom-width:0px;">
						<div class="styGenericDiv" style="width:256mm;height:4mm;">
							<div class="styPartName" style="width:15mm;">Part IV</div>
							<div class="styPartDesc" style="padding-left:3mm;width:190mm;">
                Carryovers of General Business Credits (GBCs)
					<span class="styNormalText"> (see instructions)</span>
							</div>
						</div>
					</div>
					<div class="styTableContainer" id="PartIVTable1Ctn" style="height:auto;display:block;border-bottom-width:2px; width: 256mm;">
						<table class="styTable" cellspacing="0" name="PartIVTable1" id="PartIVTable1">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartIVTableCellHeader" colspan="5"></th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="4">Carryover</th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="2" style="border-right-width: 0;"></th>
								</tr>

								<tr style="min-height:13mm;">
									<th class="styIRS3800PartIVTableCellHeader" style="width:8mm;border-right-width:0px; border-top-width: 0;" scope="col"  rowspan="2"/>
									<th class="styIRS3800PartIVTableCellHeader" style="width:43mm; border-top-width: 0;" scope="col"  rowspan="2">
										Credits carried over to tax year 2024 
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:30mm; width: 20mm; " scope="col" rowspan="2">
										<b>(a)</b>
										<br/>No. of items
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:20mm;" scope="col" rowspan="2">
										<b>(b)</b>
										<br/>Originating tax year
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(c)</b>
										<br/>Pass-through entity EIN
									</th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="2" scope="col">
										<b>Subject to the passive activity limits</b>
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(f)</b>
										<br/>Not subject to passive activity limits
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(g)</b>
										<br/>Amount of columns (e) and (f) applied against tax in Part II
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(h)</b>
										<br/>Amount of columns (e) and (f) recaptured or otherwise adjusted
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="border-right-width:0px;" scope="col" rowspan="2">
										<b>(i)</b>
										<br/>Carryforward to 2025. Subtract the sum of columns (g) and (h) from the sum of columns (e) and (f)
									</th>
								</tr>
								<tr>
									<th class="styIRS3800PartIVTableCellHeader" style="width:12mm;" scope="col">
										<b>(d)</b>
										<br/><b>Before</b> the passive activity limitations
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:12mm;" scope="col">
										<b>(e)</b>
										<br/><b>After</b> the passive activity limitations
									</th>
								</tr>
							</thead>
							
							<tbody>
								<!-- Part IV, Line 1a -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm3468PartIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">1a</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1b -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm7207CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">b</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7207</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1c -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm6765CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">c</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6765</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1d -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm3468PartIIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">d</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part III</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1e -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8826CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">e</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8826</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1f -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8835PartIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">f</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8835, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1g -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm7210CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">g</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7210</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1h -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8820CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">h</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8820</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1i -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8874CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">i</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8874</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1j -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8881PartICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">j</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8881, Part I</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1k -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8882CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">k</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8882</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1l -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8864BiodieselCYCreditsGrp"/>
									<xsl:with-param name="RowNumber">l</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8864</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1m -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8896CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">m</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8896</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1n -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8906CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">n</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8906</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1o -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm3468PartIVCYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">o</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part IV</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1p -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8908CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">p</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8908</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1q -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">q</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1r -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">r</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1s -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8911CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">s</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8911</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1t -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8830CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">t</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8830</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1u -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm7213PartIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">u</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7213, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1v -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm3468PartVCYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">v</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part V</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1w -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8932CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">w</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8932</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1x -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8933CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">x</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8933</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1y -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8936PartIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">y</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8936, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1z -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">z</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1aa -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8936PartVCYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">aa</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8936, Part V</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1bb -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8904CYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">bb</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8904</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1cc -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm7213PartICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">cc</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 7213, Part I</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1dd -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8881PartIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">dd</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8881, Part II</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1ee -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8881PartIIICYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">ee</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8881, Part III</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1ff -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8864SAFCYCyovCrGrp"/>
									<xsl:with-param name="RowNumber">ff</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8864</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 1gg -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">gg</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1hh -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">hh</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1ii -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">ii</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1jj -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">jj</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 1zz -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCyovOtherBusCreditsGrp"/>
									<xsl:with-param name="RowNumber">zz</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Other</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
							</tbody>
						</table>
					</div>
					<!--Page 5 Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
								
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part IV Table 1 START ============================================== -->
					<!-- =============================================================================================================== -->
					<!-- Page 6 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">6</span>
						</div>
					</div>

					<div class="styBB" style="width:256mm;border-top-width:2px;border-bottom-width:0px;">
						<div class="styGenericDiv" style="width:256mm;height:4mm;">
							<div class="styPartName" style="width:15mm;">Part IV</div>
							<div class="styPartDesc" style="padding-left:3mm;width:190mm;">
                Carryovers of General Business Credits (GBCs)
					<span class="styNormalText"> (see instructions) <i> (continued) </i>
								</span>
							</div>
						</div>
					</div>
					<div class="styTableContainer" id="PartIVTable2Ctn" style="height:auto;display:block;border-bottom-width:2px; width: 256mm;">
						<table class="styTable" cellspacing="0" name="PartIVTable2" id="PartIVTable2">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartIVTableCellHeader" colspan="5"></th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="4">Carryover</th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="2" style="border-right-width: 0;"></th>
								</tr>

								<tr style="min-height:13mm;">
									<th class="styIRS3800PartIVTableCellHeader" style="width:8mm;border-right-width:0px; border-top-width: 0;" scope="col"  rowspan="2"/>
									<th class="styIRS3800PartIVTableCellHeader" style="width:43mm; border-top-width: 0;" scope="col"  rowspan="2">
										Credits carried over to tax year 2024 
										<br /><b>Note:</b> Credits on lines 2a through 2x are expired. Only carryforwards are allowed.
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:30mm; width: 20mm; " scope="col" rowspan="2">
										<b>(a)</b>
										<br/>No. of items
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:20mm;" scope="col" rowspan="2">
										<b>(b)</b>
										<br/>Originating tax year
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(c)</b>
										<br/>Pass-through entity EIN
									</th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="2" scope="col">
										<b>Subject to the passive activity limits</b>
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(f)</b>
										<br/>Not subject to passive activity limits
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(g)</b>
										<br/>Amount of columns (e) and (f) applied against tax in Part II
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(h)</b>
										<br/>Amount of columns (e) and (f) recaptured or otherwise adjusted
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="border-right-width:0px;" scope="col" rowspan="2">
										<b>(i)</b>
										<br/>Carryforward to 2025. Subtract the sum of columns (g) and (h) from the sum of columns (e) and (f)
									</th>
								</tr>
								<tr>
									<th class="styIRS3800PartIVTableCellHeader" style="width:12mm;" scope="col">
										<b>(d)</b>
										<br/><b>Before</b> the passive activity limitations
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:12mm;" scope="col">
										<b>(e)</b>
										<br/><b>After</b> the passive activity limitations
									</th>
								</tr>
							</thead>
							<tbody>
								<!-- Part IV Line 2a -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm5884ACYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">a</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884-A</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2b -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8586CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">b</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8586 (pre-2008)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2c -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8845CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">c</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8845</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2d -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8907CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">d</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8907</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2e -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8909CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">e</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8909</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2f  -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8923CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">f</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8923</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2g  -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8834PartICYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">g</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8834</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2h -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8931CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">h</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8931</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2i  -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm1065BCYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">i</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 1065-B</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2j -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm5884CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">j</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884 (pre-2007)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2k -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm6478CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">k</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6478 (pre-2005)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2l -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8846CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">l</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8846 (pre-2007)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2m -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8900CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">m</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8900 (pre-2008)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2n -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCfwdAllwCrTransAKPipelineGrp"/>
									<xsl:with-param name="RowNumber">n</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Trans-Alaska pipeline liability</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2o -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCfwdAllwCrEmplrAffctHrrcnGrp"/>
									<xsl:with-param name="RowNumber">o</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884-A, Section A</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2p -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCfwdAllwCrHrrcnKtrnHsngGrp"/>
									<xsl:with-param name="RowNumber">p</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884-A, Section B</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2q -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCfwdAllwCrMwdDsstrEmplrGrp"/>
									<xsl:with-param name="RowNumber">q</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884-A, Section A</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2r -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCfwdAllwCrEmplrHsngGrp"/>
									<xsl:with-param name="RowNumber">r</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884-A, Section B</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2s -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm5884BCYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">s</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884-B</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2t -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8847CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">t</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8847</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2u -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8861CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">u</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8861</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2v -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8884CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">v</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8884</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2w -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8942CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">w</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8942</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2x -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8910CYCfwdAllwCrGrp"/>
									<xsl:with-param name="RowNumber">x</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8910</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 2y -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">y</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 2z -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">z</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 2zz -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYCfwdAllwOtherBusCreditsGrp"/>
									<xsl:with-param name="RowNumber">zz</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Other credits (see inst.)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>

								<!-- Part IV Line 3 -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8844CYCrovCrGrp"/>
									<xsl:with-param name="RowNumber">3</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8844</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
							</tbody>
						</table>
					</div>
					<!--Page 5 Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part IV Table 1 START ============================================== -->
					<!-- =============================================================================================================== -->
					<!-- Page 7 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">7</span>
						</div>
					</div>

					<div class="styBB" style="width:256mm;border-top-width:2px;border-bottom-width:0px;">
						<div class="styGenericDiv" style="width:256mm;height:4mm;">
							<div class="styPartName" style="width:15mm;">Part IV</div>
							<div class="styPartDesc" style="padding-left:3mm;width:190mm;">
                Carryovers of General Business Credits (GBCs)
					<span class="styNormalText"> (see instructions) <i> (continued) </i>
								</span>
							</div>
						</div>
					</div>
					<div class="styTableContainer" id="PartIVTable2Ctn" style="height:auto;display:block;border-bottom-width:2px; width: 256mm;">
						<table class="styTable" cellspacing="0" name="PartIVTable2" id="PartIVTable2">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartIVTableCellHeader" colspan="5"></th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="4">Carryover</th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="2" style="border-right-width: 0;"></th>
								</tr>

								<tr style="min-height:13mm;">
									<th class="styIRS3800PartIVTableCellHeader" style="width:8mm;border-right-width:0px; border-top-width: 0;" scope="col"  rowspan="2"/>
									<th class="styIRS3800PartIVTableCellHeader" style="width:43mm; border-top-width: 0;" scope="col"  rowspan="2">
										Credits carried over to tax year 2024 
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:30mm; width: 20mm; " scope="col" rowspan="2">
										<b>(a)</b>
										<br/>No. of items
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:20mm;" scope="col" rowspan="2">
										<b>(b)</b>
										<br/>Originating tax year
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(c)</b>
										<br/>Pass-through entity EIN
									</th>
									<th class="styIRS3800PartIVTableCellHeader" colspan="2" scope="col">
										<b>Subject to the passive activity limits</b>
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(f)</b>
										<br/>Not subject to passive activity limits
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(g)</b>
										<br/>Amount of columns (e) and (f) applied against tax in Part II
									</th>
									<th class="styIRS3800PartIVTableCellHeader" scope="col" rowspan="2">
										<b>(h)</b>
										<br/>Amount of columns (e) and (f) recaptured or otherwise adjusted
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="border-right-width:0px;" scope="col" rowspan="2">
										<b>(i)</b>
										<br/>Carryforward to 2025. Subtract the sum of columns (g) and (h) from the sum of columns (e) and (f)
									</th>
								</tr>
								<tr>
									<th class="styIRS3800PartIVTableCellHeader" style="width:12mm;" scope="col">
										<b>(d)</b>
										<br/><b>Before</b> the passive activity limitations
									</th>
									<th class="styIRS3800PartIVTableCellHeader" style="width:12mm;" scope="col">
										<b>(e)</b>
										<br/><b>After</b> the passive activity limitations
									</th>
								</tr>
							</thead>
							<tbody>
								<!-- Part IV Line 4 -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">4</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Specified credits:</xsl:with-param>
									<xsl:with-param name="ColA">nofill</xsl:with-param>
									<xsl:with-param name="ColB">nofill</xsl:with-param>
									<xsl:with-param name="ColC">nofill</xsl:with-param>
									<xsl:with-param name="ColD">nofill</xsl:with-param>
									<xsl:with-param name="ColE">nofill</xsl:with-param>
									<xsl:with-param name="ColF">nofill</xsl:with-param>
									<xsl:with-param name="ColG">nofill</xsl:with-param>
									<xsl:with-param name="ColH">nofill</xsl:with-param>
									<xsl:with-param name="ColI">nofill</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 4a -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm3468PartVICYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">a</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part VI</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4b -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm5884CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">b</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 5884</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4c -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm6478CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">c</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6478</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4d -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8586CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">d</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8586 (post-2007)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4e -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8835CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">e</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8835</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4f -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8846CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">f</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8846</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4g -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8900CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">g</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8900</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4h -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8941CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">h</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8941</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4i -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm6765ESBCYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">i</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 6765 ESB credit</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4j -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm8994CYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">j</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 8994</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4k -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Frm3468PartVIICYSpcfdCrGrp"/>
									<xsl:with-param name="RowNumber">k</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Form 3468, Part VII (post-2007)</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 4l -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">l</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 4m -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath"/>
									<xsl:with-param name="RowNumber">m</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Reserved</xsl:with-param>
									<xsl:with-param name="ColA">lightgrey</xsl:with-param>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC">lightgrey</xsl:with-param>
									<xsl:with-param name="ColD">lightgrey</xsl:with-param>
									<xsl:with-param name="ColE">lightgrey</xsl:with-param>
									<xsl:with-param name="ColF">lightgrey</xsl:with-param>
									<xsl:with-param name="ColG">lightgrey</xsl:with-param>
									<xsl:with-param name="ColH">lightgrey</xsl:with-param>
									<xsl:with-param name="ColI">lightgrey</xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 4y -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/ESCBCYCreditsGrp" />
									<xsl:with-param name="RowNumber">y</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">ESBC (See inst.)</xsl:with-param>
									<xsl:with-param name="ColA"></xsl:with-param>
									<xsl:with-param name="ColB"></xsl:with-param>
									<xsl:with-param name="ColC"></xsl:with-param>
									<xsl:with-param name="ColD"></xsl:with-param>
									<xsl:with-param name="ColE"></xsl:with-param>
									<xsl:with-param name="ColF"></xsl:with-param>
									<xsl:with-param name="ColG"></xsl:with-param>
									<xsl:with-param name="ColH"></xsl:with-param>
									<xsl:with-param name="ColI"></xsl:with-param>
								</xsl:call-template>
								<!-- Part IV Line 4z -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYOtherSpcfdCreditsGrp"/>
									<xsl:with-param name="RowNumber">z</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Other specified credits</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB"/>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 5 -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/CYOtherSpcfdCreditsSubTotGrp"/>
									<xsl:with-param name="RowNumber">5</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Add lines 4a-4z</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 6 -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/TotCYGBCOrESBCAmtGrp"/>
									<xsl:with-param name="RowNumber">6</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Add lines 1a through 2zz</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
								<!-- Part IV Line 7 -->
								<xsl:call-template name="Part4TableRows">
									<xsl:with-param name="GroupPath" select="$Form3800Data/Tot8844OthSpcfdGBCOrESBCAmtGrp"/>
									<xsl:with-param name="RowNumber">7</xsl:with-param>
									<xsl:with-param name="Dots"/>
									<xsl:with-param name="ColFormName">Add lines 3, 5 and 6</xsl:with-param>
									<xsl:with-param name="ColA"/>
									<xsl:with-param name="ColB">lightgrey</xsl:with-param>
									<xsl:with-param name="ColC"/>
									<xsl:with-param name="ColD"/>
									<xsl:with-param name="ColE"/>
									<xsl:with-param name="ColF"/>
									<xsl:with-param name="ColG"/>
									<xsl:with-param name="ColH"/>
									<xsl:with-param name="ColI"/>
								</xsl:call-template>
							</tbody>
						</table>
					</div>
					<!--Page 7 Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ========================================== Part IV Table 1 END ================================================ -->
					<!-- =============================================================================================================== -->
					<!-- =============================================================================================================== -->
					<!-- ===============================================Part V START =================================================== -->
					<!-- =============================================================================================================== -->
					<!-- Page 7 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">8</span>
						</div>
					</div>
					<xsl:variable name="PartVGroups" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
					<xsl:variable name="PartVGroupCount" select="count($PartVGroups)"/>
					<div class="styBB" style="width:256mm;border-top-width:1px; border-bottom-width: 0;">
						<div class="styGenericDiv" style="width:256mm;">
							<div class="styPartName" style="width:15mm;">Part V</div>
							<div class="styPartDesc" style="padding-left:3mm;width:200mm;">
							Breakdown of Aggregate Amounts on Part III for Facility-by-Facility, Multiple Pass-Through Entities, etc.
							
							</div>
							<div style="float:right;">
								<xsl:call-template name="SetDynamicTableToggleButton">
									<xsl:with-param name="TargetNode" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
									<xsl:with-param name="containerHeight" select="15"/>
									<xsl:with-param name="headerHeight" select="1"/>
									<xsl:with-param name="containerID" select=" 'PartVTableCtn' "/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<div class="styTableContainerLandscape" style="height:auto; display:block;" id="PartVTableCtn">
						<!--<xsl:call-template name="SetInitialState"/>-->
						<table class="styTable" cellspacing="0" name="PartVTable" id="PartVTable">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartVTableCellHeader" colspan="5" style="border-bottom-width: 0; border-top-width: 1px"></th>
									<th class="styIRS3800PartVTableCellHeader" colspan="3" style="border-top-width: 1px"><b>Credits subject to the passive activity limit</b></th>
									<th class="styIRS3800PartVTableCellHeader" colspan="3" style="border-right-width: 0; border-top-width: 1px;"><b>Not subject to the limit</b></th>
								</tr>
								<tr>
									<th class="styIRS3800PartVTableCellHeader" style="width:12mm;" rowspan="2"/>
									<th class="styIRS3800PartVTableCellHeader" scope="col" rowspan="2" style="border-top-width: 1px; width: 31mm;">
										<b>(a)</b>
										<br/> Part III line number
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="width:33mm; border-top-width: 1px;" rowspan="2">
										<b>(b)</b>
										<br/> Elective payment or transfer registration number
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="width:36mm; border-top-width: 1px;" colspan="2" >
										<b>EINs</b>
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="width:36mm;" colspan="3">
										<b>Before applying the limit</b>
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" rowspan="2">
										<b>(d)(4)</b>
										<br/> Credits from column (d)(1) (less column (d)(2)) and (d)(3) allowed after limit
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" rowspan="2">
										<b>(e)</b>
										<br/> Credits other than transfer election credits
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" rowspan="2" style="border-right-width: 0; width: 28mm;">
										<b>(f)(1)</b>
										<br/> Transfer election credits sold
									</th>
								</tr>
								<tr>
									<th class="styIRS3800PartVTableCellHeader" scope="col">
										<b>(c)(1)</b>
										<br/> Pass-through entity EIN
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col">
										<b>(c)(2)</b>
										<br/> Transferor entity EIN
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col">
										<b>(d)(1)</b>
										<br/> Credits other than credit transfer election credits
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="width: 28mm;">
										<b>(d)(2)</b>
										<br/> Credit transfer election credits sold
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col">
										<b>(d)(3)</b>
										<br/> Credit transfer election credits purchased
									</th>
								</tr>
							</thead>
							<tbody>
								<xsl:if test="($Print != $Separated) or	(($Print = $Separated) and ($PartVGroupCount &lt;=15))">
									<xsl:for-each select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]">
										<tr style="min-height:4mm;">
											<td class="styTableCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;border-bottom:none;">
												<xsl:if test="position() = last() and position() &gt;= 15">
													<xsl:attribute name="style">width:12mm;vertical-align:top;text-align:right;padding-right:5mm;</xsl:attribute>
												</xsl:if>
												<b>
													<xsl:value-of select="position()"/>
												</b>
											</td>
											<td class="styIRS3800PartVTableCell">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="@lineNumberTxt"/>
												</xsl:call-template>
												
												<span style="padding-left: 3px" />
												
												<xsl:call-template name="SetFormLinkInline">
													<xsl:with-param name="TargetNode" select="."/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableCell" style="width:36mm;">
												<xsl:choose>
													<xsl:when test="ElectivePaymentRegistrationNum">
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="ElectivePaymentRegistrationNum"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="TransferRegistrationNum"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styIRS3800PartVTableCell" style="text-align:center;">
												<xsl:choose>
													<xsl:when test="PassThroughEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="PassThroughEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styIRS3800PartVTableCell" style="text-align:center;">
												<xsl:choose>
													<xsl:when test="TransferCreditEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="TransferCreditEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="OthThnCrTrnsfrElectCrBfrLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												(
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrTrnsfrElectCrSoldBfrLmtAmt"/>
												</xsl:call-template>
												)
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrTrnsfrElectCrPrchsBfrLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrTrnsfrElectCrAllwAftrLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="OthThnCrTrnsfrElectCrNoLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:choose>
													<xsl:when test="TrnsfrElectCrSoldNoLmtAmt">
														(
														<xsl:call-template name="PopulateAmount">
															<xsl:with-param name="TargetNode" select="TrnsfrElectCrSoldNoLmtAmt"/>
														</xsl:call-template>
														)
													</xsl:when>
													<xsl:otherwise>
														<span style="float: left;">(</span><span style="float: right;">)</span>
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>

									</xsl:for-each>
								</xsl:if>
								<xsl:if test="($PartVGroupCount &lt; 15)">
									<xsl:call-template name="PartVBlankRows">
										<xsl:with-param name="numRows" select="15 - $PartVGroupCount"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="($Print = $Separated) and ($PartVGroupCount &gt; 15)">
									<xsl:call-template name="PartVBlankRows">
										<xsl:with-param name="numRows" select="15"/>
									</xsl:call-template>
								</xsl:if>
							</tbody>
						</table>
					</div>
					<xsl:if test="($Print != $Separated)">
						<xsl:call-template name="SetInitialDynamicTableHeight">
							<xsl:with-param name="TargetNode" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
							<xsl:with-param name="containerHeight" select="17"/>
							<xsl:with-param name="headerHeight" select="1"/>
							<xsl:with-param name="containerID" select=" 'PartVTableCtn' "/>
						</xsl:call-template>
					</xsl:if>

					<div class="styBB" style="width:256mm;border-top-width:0px; border-bottom-width: 0; height: 0;">
						<div class="styGenericDiv" style="width:256mm;">
							<div style="float:right;">
								<xsl:call-template name="SetDynamicTableToggleButton">
									<xsl:with-param name="TargetNode" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
									<xsl:with-param name="containerHeight" select="15"/>
									<xsl:with-param name="headerHeight" select="1"/>
									<xsl:with-param name="containerID" select=" 'PartVTableCtn2' "/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<div class="styTableContainerLandscape" style="height:auto;display:block;" id="PartVTableCtn2">
						<xsl:call-template name="SetInitialState"/>
						<table class="styTable" cellspacing="0" name="PartVTable" id="PartVTable">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartVTableCellHeader" style="width:12mm; border-top-width: 1px;" rowspan="2"/>
									<th class="styIRS3800PartVTableCellHeader" scope="col" rowspan="2" style="border-top-width: 1px; width: 45mm">
										<b>(f)(2)</b>
										<br/> Purchased transfer election credits not subject to the passive activity limit
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="width:36mm; border-top-width: 1px;">
										<b>(g)</b>
										<br/> Combine columns (d)(4), (e), (f)(1), and (f)(2)
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="width:36mm; border-top-width: 1px;">
										<b>(h)(1)</b>
										<br />Gross EPE amount. Portion of column (g) eligible for the section 6417 EPE election
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="border-top-width: 1px;">
										<b>(h)(2)</b>
										<br/> Subtract column (h)(1) from column (g) (credit excluding EPE)
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="border-top-width: 1px;">
										<b>(i)(1)</b>
										<br/> Amount of column (h)(2) applied against tax in Part II
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="border-top-width: 1px;">
										<b>(i)(2)</b>
										<br/>Amount of EPE eligible credit in column (h)(1) applied against tax in Part II
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="border-top-width: 1px;">
										<b>(j)</b>
										<br/>Net EPE amount. Subtract (i)(2) from column (h)(1)
									</th>
									<th class="styIRS3800PartVTableCellHeader" scope="col" style="border-right-width: 0;border-top-width: 1px;">
										<b>(k)</b>
										<br/>Carryforward to 2025. Subtract (i)(1) from column (h)(2)
									</th>
								</tr>
							</thead>
							<tbody>
								<xsl:if test="($Print != $Separated) or	(($Print = $Separated) and ($PartVGroupCount &lt;=15))">
									<xsl:for-each select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]">
										<tr style="min-height:4mm;">
											<td class="styTableCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;border-bottom:none;">
												<xsl:if test="position() = last() and position() &gt;= 15">
													<xsl:attribute name="style">width:12mm;vertical-align:top;text-align:right;padding-right:5mm;</xsl:attribute>
												</xsl:if>
												<b>
													<xsl:value-of select="position()"/>
												</b>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PrchsTrnsfrElectCrNoLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGeneralBusCreditsAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GrossElectivePymtElectionAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGBCLessGrossEPEAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGBCLessGrossEPEAppTxAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="EPEEligibleCrAppTxAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="NetElectivePymtElectionAmt"/>
												</xsl:call-template>
											</td>
											<td class="styIRS3800PartVTableAmountCell">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CarryforwardGeneralBusCrAmt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>
								<xsl:if test="($PartVGroupCount &lt; 15)">
									<xsl:call-template name="PartV2BlankRows">
										<xsl:with-param name="numRows" select="15 - $PartVGroupCount"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="($Print = $Separated) and ($PartVGroupCount &gt; 15)">
									<xsl:call-template name="PartV2BlankRows">
										<xsl:with-param name="numRows" select="15"/>
									</xsl:call-template>
								</xsl:if>
							</tbody>
						</table>
					</div>
					<xsl:call-template name="SetInitialDynamicTableHeight">
						<xsl:with-param name="TargetNode" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
						<xsl:with-param name="containerHeight" select="15"/>
						<xsl:with-param name="headerHeight" select="1"/>
						<xsl:with-param name="containerID" select=" 'PartVTableCtn2' "/>
					</xsl:call-template>
					<!--Page 7 Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ===============================================Part V END ===================================================== -->
					<!-- =============================================================================================================== -->
					<!-- =============================================================================================================== -->
					<!-- ===============================================Part 6 START =================================================== -->
					<!-- =============================================================================================================== -->
					<xsl:variable name="PartVIGroups" select="$Form3800Data/*[contains(name(),'AggrgtGrp') or contains(name(),'AggrgtAmtGrp')]"/>
					<xsl:variable name="PartVIGroupCount" select="count($PartVIGroups)"/>
					<!-- Page 5 Header -->
					<div style="width:256mm;clear:both;padding-bottom:.5mm;" class="styNBB">
						<div style="width:90mm;" class="styGenericDiv">Form 3800 (2024)</div>
						<div style="width:55mm;text-align:center;" class="styGenericDiv"/>
						<div style="float:right;" class="styGenericDiv">Page <span class="styBoldText" style="font-size:8pt;">9</span>
						</div>
					</div>
					<!-- Begin Part VI - Breakdown of Aggregate Amounts in Part IV -->
					<div class="styBB" style="width:256mm;border-top-width:2px;border-bottom-width:0px;">
						<div class="styGenericDiv" style="width:256mm;height:4mm;">
							<div class="styPartName" style="width:15mm;">Part VI</div>
							<div class="styPartDesc" style="padding-left:3mm;width:190mm;">
                Breakdown of Aggregate Amounts in Part IV
					<span class="styNormalText"> (see instructions)
								</span>
							</div>
							
							<div style="float:right;">
								<xsl:call-template name="SetDynamicTableToggleButton">
									<xsl:with-param name="TargetNode" select="$Form3800Data/*[contains(name(),'AggrgtGrp')]"/>
									<xsl:with-param name="containerHeight" select="35"/>
									<xsl:with-param name="headerHeight" select="1"/>
									<xsl:with-param name="containerID" select=" 'PartVITableCtn' "/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<div class="styTableContainer" id="PartVITableCtn" style="height:auto;display:block;border-bottom-width:2px; width: 256mm;">
						<table class="styTable" cellspacing="0" name="PartVITable" id="PartVITable">
							<thead class="styTableThead">
								<tr>
									<th class="styIRS3800PartVITableCellHeader" colspan="5"></th>
									<th class="styIRS3800PartVITableCellHeader" colspan="4">Carryover</th>
									<th class="styIRS3800PartVITableCellHeader" colspan="2" style="border-right-width: 0;"></th>
								</tr>

								<tr style="min-height:13mm;">
									<th class="styIRS3800PartVITableCellHeader" style="width:8mm;border-right-width:0px; border-top-width: 0;" scope="col"  rowspan="2"/>
									<th class="styIRS3800PartVITableCellHeader" style="width:30mm; width: 20mm; border-bottom-width: 1px; " scope="col" rowspan="2">
										<b>(a)</b>
										<br/>Line number from Part IV
									</th>
									<th class="styIRS3800PartVITableCellHeader" style="width:20mm; border-bottom-width: 1px;" scope="col" rowspan="2">
										<b>(b)</b>
										<br/>Originating tax year
									</th>
									<th class="styIRS3800PartVITableCellHeader" scope="col" rowspan="2" style="border-bottom-width: 1px;">
										<b>(c)</b>
										<br/>Pass-through entity EIN
									</th>
									<th class="styIRS3800PartVITableCellHeader" colspan="2" scope="col">
										<b>Subject to the passive activity limits</b>
									</th>
									<th class="styIRS3800PartVITableCellHeader" scope="col" rowspan="2" style="border-bottom-width: 1px;">
										<b>(f)</b>
										<br/>Not subject to passive activity limits
									</th>
									<th class="styIRS3800PartVITableCellHeader" scope="col" rowspan="2" style="border-bottom-width: 1px;">
										<b>(g)</b>
										<br/>Amount of columns (e) and (f) applied against tax in Part II
									</th>
									<th class="styIRS3800PartVITableCellHeader" scope="col" rowspan="2" style="border-bottom-width: 1px;">
										<b>(h)</b>
										<br/>Amount of columns (e) and (f) recaptured or otherwise adjusted
									</th>
									<th class="styIRS3800PartVITableCellHeader" style="border-right-width:0px; border-bottom-width: 1px;" scope="col" rowspan="2">
										<b>(i)</b>
										<br/>Carryforward to 2025. Subtract the sum of columns (g) and (h) from the sum of columns (e) and (f)
									</th>
								</tr>
								<tr>
									<th class="styIRS3800PartVITableCellHeader" style="width:12mm;border-bottom-width: 1px;" scope="col">
										<b>(d)</b>
										<br/><b>Before</b> the passive activity limitations
									</th>
									<th class="styIRS3800PartVITableCellHeader" style="width:12mm; border-bottom-width: 1px;" scope="col">
										<b>(e)</b>
										<br/><b>After</b> the passive activity limitations
									</th>
								</tr>
							</thead>
							<tbody>
							
							<!-- or	(($Print = $Separated) and (count($Form3800Data/Frm3468PartIICYCyovCrAggrgtGrp) &gt;35))-->
								<xsl:if test="($Print != $Separated) ">
									<xsl:for-each select="$Form3800Data/*[contains(name(),'AggrgtGrp') ]">
										<tr style="min-height:4mm;">
											<td class="styTableCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;border:none;">
												<xsl:if test="position() = last() and position() &gt;= 35">
													<xsl:attribute name="style">width:12mm;vertical-align:top;text-align:right;padding-right:5mm;border-width:0px;</xsl:attribute>
												</xsl:if>
												<span style="font-weight:bold;text-align:right;">
													<xsl:value-of select="position()"/>
												</span>
											</td>
											<td class="styTableCell" style="width:32mm;vertical-align:top;text-align:left;">
												<xsl:if test="position() = last() and position() &gt;= 35">
													<xsl:attribute name="style">width:32mm;vertical-align:top;text-align:left;border-bottom-width:1px;</xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="./@lineNumberTxt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="width:15mm;text-align:center;vertical-align:middle;">
												<xsl:if test="position() = last() and position() &gt; 35">
													<xsl:attribute name="style">width:15mm;text-align:center;vertical-align:middle;border-bottom-width:1px;</xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="Yr"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="width:26mm;text-align:center;vertical-align:middle;">
												<xsl:if test="position() = last() and position() &gt; 35">
													<xsl:attribute name="style">width:26mm;text-align:center;vertical-align:middle;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:choose>
													<xsl:when test="PassThroughEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="PassThroughEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styTableCell" style="width:28mm;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">width:28mm;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrSubjToPassiveActyLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="width:28mm;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">width:28mm;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PassiveActivityCrAfterLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="border-right-width:1px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:1px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrFromNnPssvActyAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="border-right-width:1px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:1px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGeneralBusCreditsAppTxAmt"/>
												</xsl:call-template>													
											</td>
											<td class="styTableCell" style="border-right-width:1px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:1px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrCyovRcptrAdjAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="border-right-width:0px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:0px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CarryforwardGeneralBusCrAmt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
									
									
									<xsl:variable name="PartVIGroupCounts" select="count($Form3800Data/*[contains(name(),'AggrgtGrp')])"/>
									
									<xsl:for-each select="($Form3800Data/Tot8844GBCOrESBCAggrgtAmtGrp)[1]">
										<tr style="min-height:4mm;">
											<td class="styTableCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;border:none;">
												<xsl:if test="position() = last() and position() &gt;= 35">
													<xsl:attribute name="style">width:12mm;vertical-align:top;text-align:right;padding-right:5mm;border-width:0px 0px 1px 0px;</xsl:attribute>
												</xsl:if>
												<span style="font-weight:bold;text-align:right;">
													<xsl:value-of select="($PartVIGroupCounts + 1)"/>
												</span>
											</td>
											<td class="styTableCell" style="width:32mm;vertical-align:top;text-align:left;">
												<xsl:if test="position() = last() and position() &gt;= 35">
													<xsl:attribute name="style">width:32mm;vertical-align:top;text-align:left;border-bottom-width:1px;</xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="./@lineNumberTxt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="width:15mm;text-align:center;vertical-align:middle;">
												<xsl:if test="position() = last() and position() &gt; 35">
													<xsl:attribute name="style">width:15mm;text-align:center;vertical-align:middle;border-bottom-width:1px;</xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="Yr"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="width:26mm;text-align:center;vertical-align:middle;">
												<xsl:if test="position() = last() and position() &gt; 35">
													<xsl:attribute name="style">width:26mm;text-align:center;vertical-align:middle;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:choose>
													<xsl:when test="PassThroughEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="PassThroughEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styTableCell" style="width:28mm;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">width:28mm;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrSubjToPassiveActyLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="width:28mm;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">width:28mm;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PassiveActivityCrAfterLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="border-right-width:1px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:1px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrFromNnPssvActyAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="border-right-width:1px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:1px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:choose>
													<xsl:when test="GeneralBusCrCyovRcptrAdjAmt != ''">
														<xsl:call-template name="PopulateAmount">
															<xsl:with-param name="TargetNode" select="GeneralBusCrCyovRcptrAdjAmt"/>
														</xsl:call-template>	
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateAmount">
															<xsl:with-param name="TargetNode" select="TotalGeneralBusCreditsAppTxAmt"/>
														</xsl:call-template>													
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styTableCell" style="border-right-width:1px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:1px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrCyovRcptrAdjAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCell" style="border-right-width:0px;">
												<xsl:if test="position() = last() and position() &gt;35">
													<xsl:attribute name="style">border-right-width:0px;border-bottom-width:1px; </xsl:attribute>
												</xsl:if>
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CarryforwardGeneralBusCrAmt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>
								<xsl:if test="($PartVIGroupCount &lt; 35)">
									<xsl:call-template name="PartVIBlankRows">
										<xsl:with-param name="numRows" select="35 - $PartVIGroupCount"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="($Print = $Separated) and ($PartVIGroupCount &gt; 35)">
									<xsl:call-template name="PartVIBlankRows">
										<xsl:with-param name="numRows" select="35"/>
									</xsl:call-template>
								</xsl:if>
							</tbody>
						</table>
					</div>
					<xsl:if test="($Print != $Separated)">
						<xsl:call-template name="SetInitialDynamicTableHeight">
							<xsl:with-param name="TargetNode" select="$Form3800Data/*[contains(name(),'AggrgtGrp')]"/>
							<xsl:with-param name="containerHeight" select="35"/>
							<xsl:with-param name="headerHeight" select="1"/>
							<xsl:with-param name="containerID" select=" 'PartVITableCtn' "/>
						</xsl:call-template>
					</xsl:if>

					<!--Page 8 Footer -->
					<div class="styStdDiv pageEnd" style="width:256mm;">
						<span style="font-weight:bold;"/>
						<span style="margin-left:24mm;"/>
						<span style="float:right;">Form <b>3800</b> (2024)</span>
					</div>
					<!-- =============================================================================================================== -->
					<!-- ===============================================Part 6 END ===================================================== -->
					<!-- =============================================================================================================== -->
					<div class="styGenericDiv" style="width:256mm;clear:all;">
						<!--ADDITIONAL DATA SECTION-->
						<div class="styLeftOverTitleLine" id="LeftoverData" style="width: 256mm;">
							<div class="styLeftOverTitle">
								Additional Data      
							 </div>
							<div class="styLeftOverButtonContainer" style="width: 220mm;">
								<input class="styLeftoverTableBtn" tabindex="1" type="button" value="Return to Form" onclick="javascript:returnToWriteInImage();"/>
							</div>
						</div>
						<table class="styLeftOverTbl">
							<xsl:call-template name="PopulateCommonLeftover">
								<xsl:with-param name="TargetNode" select="$Form3800Data"/>
								<xsl:with-param name="DescWidth" select="100"/>
							</xsl:call-template>
							<xsl:call-template name="PopulateLeftoverRow">
								<xsl:with-param name="Desc">Line 17 - sec383 or sec384 Indicator</xsl:with-param>
								<xsl:with-param name="TargetNode" select="$Form3800Data/SmllrCYNotAllwTMTOrTotAdjAmt/@section383Or384IndicatorCd"/>
								<xsl:with-param name="DescWidth" select="100"/>
							</xsl:call-template>
						</table>
						<!-- =============================================================================================================== -->
						<!-- ============================================ Part V SRD Table ================================================= -->
						<!-- =============================================================================================================== -->
						<xsl:if test="($Print = $Separated) and ($PartVGroupCount &gt; 15)">
							<div class="styGenericDiv" style="width:256mm;font-size:8pt;font-weight:bold;padding-top:4mm;padding-bottom:1mm;">
								Part V - Breakdown of Aggregate Amounts on Part III for Facility-by-Facility, Multiple Pass-Through Entities, etc.
							</div>
							<table class="styDepTblLandscape" cellspacing="0" name="PartVSRDTable" id="PartVSRDTable">
								<thead class="styTableThead">
									<tr class="styDepTblHdr">
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" colspan="5" style="border-bottom-width: 0; border-top-width: 1px; color: white;"></th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" colspan="3" style="border-top-width: 1px; color: white;"><b>Credits subject to the passive activity limit</b></th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" colspan="3" style="border-right-width: 0; border-top-width: 1px; color: white;"><b>Not subject to the limit</b></th>
									</tr>
									<tr class="styDepTblHdr">
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" style="width:12mm; color: white;" rowspan="2"/>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-top-width: 1px; color: white;">
											<b>(a)</b>
											<br/> Part III line number
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="width:36mm; border-top-width: 1px; color: white;" rowspan="2">
											<b>(b)</b>
											<br/> Elective payment or transfer registration number
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="width:36mm; border-top-width: 1px; color: white;" colspan="2" >
											<b>EINs</b>
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="width:36mm; color: white;" colspan="3">
											<b>Before applying the limit</b>
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" rowspan="2" style="color: white;">
											<b>(d)(4)</b>
											<br/> Credits from column (d)(1) (less column (d)(2)) and (d)(3) allowed after limit
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" rowspan="2" style="color: white;">
											<b>(e)</b>
											<br/> Credits other than transfer election credits
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-right-width: 0; color: white; width: 42mm;">
											<b>(f)(1)</b>
											<br/> Transfer election credits sold
										</th>
									</tr>
									<tr class="styDepTblHdr">
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="color: white;">
											<b>(c)(1)</b>
											<br/> Pass-through entity EIN
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="color: white;">
											<b>(c)(2)</b>
											<br/> Transferor entity EIN
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="color: white;">
											<b>(d)(1)</b>
											<br/> Credits other than credit transfer election credits
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="color: white; width: 42mm;">
											<b>(d)(2)</b>
											<br/> Credit transfer election credits sold
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="color: white;">
											<b>(d)(3)</b>
											<br/> Credit transfer election credits purchased
										</th>
									</tr>

								</thead>
								<tbody>
									<xsl:for-each select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]">
										<tr style="font-size:7pt;">
											<xsl:attribute name="class">
												<xsl:choose>
													<xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
													<xsl:otherwise>styDepTblRow2</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<td class="styDepTblCell" style="width:12mm;text-align:right;padding-right:3mm;">
												<b>
													<xsl:value-of select="position()"/>
												</b>
											</td>
											<!-- Part V - A-->
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="@lineNumberTxt"/>
												</xsl:call-template>
											</td>
											<!-- Part V - B-->
											<td class="styDepTblCell" style="width:36mm;text-align:left;">
												<xsl:choose>
													<xsl:when test="ElectivePaymentRegistrationNum">
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="ElectivePaymentRegistrationNum"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="TransferRegistrationNum"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<!-- Part V - C1 -->
											<td class="styDepTblCell">
												<xsl:choose>
													<xsl:when test="PassThroughEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="PassThroughEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<!-- Part V - c2 -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
													<xsl:call-template name="PopulateEIN">
														<xsl:with-param name="TargetNode" select="TransferCreditEntityEIN"/>
													</xsl:call-template>
											</td>
											<!-- Part V - D1 -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="OthThnCrTrnsfrElectCrBfrLmtAmt"/>
												</xsl:call-template>
											</td>
											<!-- Part V - D2 -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
												(
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrTrnsfrElectCrSoldBfrLmtAmt"/>
												</xsl:call-template>
												)
											</td>
											<!-- Part V - D3 -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrTrnsfrElectCrPrchsBfrLmtAmt"/>
												</xsl:call-template>
											</td>
											<!-- Part V - D3 -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrTrnsfrElectCrAllwAftrLmtAmt"/>
												</xsl:call-template>
											</td>
											<!-- Part V - E -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="OthThnCrTrnsfrElectCrNoLmtAmt"/>
												</xsl:call-template>
											</td>
											<!-- Part V - F1 -->
											<td class="styDepTblCell" style="text-align:right;vertical-align:bottom;">
												<xsl:choose>
													<xsl:when test="TrnsfrElectCrSoldNoLmtAmt">
														(
														<xsl:call-template name="PopulateAmount">
															<xsl:with-param name="TargetNode" select="TrnsfrElectCrSoldNoLmtAmt"/>
														</xsl:call-template>
														)
													</xsl:when>
													<xsl:otherwise>
														<span style="float: left;">(</span><span style="float: right;">)</span>
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
							<table class="styDepTblLandscape" cellspacing="0" name="PartVSRDTable" id="PartVSRDTable">
								<thead class="styTableThead">
									<tr class="styDepTblHdr">
										<th class="styDepTblCell" style="width:12mm; border-top-width: 1px;" rowspan="2"/>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-top-width: 1px; width: 45mm; color: white;">
											<b>(f)(2)</b>
											<br/> Purchased transfer election credits not subject to the passive activity limit
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="width:36mm; border-top-width: 1px; color: white;">
											<b>(g)</b>
											<br/> Combine columns (d)(4), (e), (f)(1), and (f)(2)
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="width:36mm; border-top-width: 1px; color: white;">
											<b>(h)(1)</b>
											<br />Gross EPE amount. Portion of column (g) eligible for the section 6417 EPE election
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="border-top-width: 1px; color: white;">
											<b>(h)(2)</b>
											<br/> Subtract column (h)(1) from column (g) (credit excluding EPE)
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="border-top-width: 1px; color: white;">
											<b>(i)(1)</b>
											<br/> Amount of column (h)(2) applied against tax in Part II
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="border-top-width: 1px; color: white;">
											<b>(i)(2)</b>
											<br/>Amount of EPE eligible credit in column (h)(1) applied against tax in Part II
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="border-top-width: 1px; color: white;">
											<b>(j)</b>
											<br/>Net EPE amount. Subtract (i)(2) from column (h)(1)
										</th>
										<th class="styIRS3800PartVTableCellHeader styDepTblCell" scope="col" style="border-right-width: 0;border-top-width: 1px; color: white;">
											<b>(k)</b>
											<br/>Carryforward to 2025. Subtract (i)(1) from column (h)(2)
										</th>
									</tr>
								</thead>
								<tbody>
									<xsl:for-each select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]">
										<tr style="font-size:7pt;">
											<xsl:attribute name="class">
												<xsl:choose>
													<xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
													<xsl:otherwise>styDepTblRow2</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<td class="styDepTblCell" style="width:12mm;text-align:right;padding-right:3mm;">
												<b>
													<xsl:value-of select="position()"/>
												</b>
											</td>
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PrchsTrnsfrElectCrNoLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGeneralBusCreditsAmt"/>
												</xsl:call-template>
											</td>											
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GrossElectivePymtElectionAmt"/>
												</xsl:call-template>
											</td>											
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGBCLessGrossEPEAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGBCLessGrossEPEAppTxAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="EPEEligibleCrAppTxAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="NetElectivePymtElectionAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="text-align:left;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CarryforwardGeneralBusCrAmt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
							<br/>
							<br/>
						</xsl:if>
						<!-- =============================================================================================================== -->
						<!-- ============================================ Part VI SRD Table ================================================ -->
						<!-- =============================================================================================================== -->
						<xsl:if test="($Print = $Separated) and ($PartVIGroupCount &gt; 35)">
							<div class="styStdDiv pageEnd"/>
							<div class="styGenericDiv" style="width:256mm;font-size:8pt;font-weight:bold;padding-bottom:1mm;">
								Part VI - Breakdown of Aggregate Amounts in Part IV (see instructions) 
							</div>
							<table class="styDepTbl" cellspacing="0" name="PartVISRDTable" id="PartVISRDTable">
								<thead class="styTableThead">
									<tr class="styDepTblHdr" style="font-size:7pt;">
										<th class="styDepTblCell" colspan="5"></th>
										<th class="styDepTblCell" colspan="4" style="font-weight: bold;">Carryover</th>
										<th class="styDepTblCell" colspan="2" style="border-right-width: 0;"></th>
									</tr>
								<tr class="styDepTblHdr" style="min-height:13mm;">
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" style="width:8mm;border-right-width:0px; border-top-width: 0;" scope="col"  rowspan="2"/>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" style="width:30mm; width: 20mm; border-bottom-width: 1px; color: white; " scope="col" rowspan="2">
										<b>(a)</b>
										<br/>Line number from Part IV
									</th>
									<th class="styIRS3800PartIVTableCellHeader styDepTblCell" style="width:20mm; border-bottom-width: 1px; color: white;" scope="col" rowspan="2">
										<b>(b)</b>
										<br/>Originating tax year
									</th>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-bottom-width: 1px; color: white;">
										<b>(c)</b>
										<br/>Pass-through entity EIN
									</th>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" colspan="2" scope="col" style="color: white; font-weight: bold;">
										<b>Subject to the passive activity limits</b>
									</th>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-bottom-width: 1px; color: white;">
										<b>(f)</b>
										<br/>Not subject to passive activity limits
									</th>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-bottom-width: 1px; color: white;">
										<b>(g)</b>
										<br/>Amount of columns (e) and (f) applied against tax in Part II
									</th>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" scope="col" rowspan="2" style="border-bottom-width: 1px; color: white;">
										<b>(h)</b>
										<br/>Amount of columns (e) and (f) recaptured or otherwise adjusted
									</th>
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" style="border-right-width:0px; border-bottom-width: 1px; color: white;" scope="col" rowspan="2">
										<b>(i)</b>
										<br/>Carryforward to 2025. Subtract the sum of columns (g) and (h) from the sum of columns (e) and (f)
									</th>
								</tr>
								<tr class="styDepTblHdr">
									<th class="styIRS3800PartVITableCellHeader styDepTblCell" style="width:12mm;border-bottom-width: 1px; color: white;" scope="col">
										<b>(d)</b>
										<br/><b>Before</b> the passive activity limitations
									</th>
									<th class="styDepTblCell styIRS3800PartVITableCellHeader" style="width:12mm; border-bottom-width: 1px; color: white;" scope="col">
										<b>(e)</b>
										<br/><b>After</b> the passive activity limitations
									</th>
								</tr>
								</thead>
								<thead class="styTableThead">
							</thead>
								<tbody>
									<xsl:for-each select="$Form3800Data/*[contains(name(),'AggrgtGrp')]">
										
										<tr style="font-size:7pt;">
											<xsl:attribute name="class">
												<xsl:choose>
													<xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
													<xsl:otherwise>styDepTblRow2</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<td class="styDepTblCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;">
												<span style="font-weight:bold;text-align:right;">
													<xsl:value-of select="position()"/>
												</span>
											</td>
											<td class="styDepTblCell" style="width:32mm;vertical-align:top;text-align:left;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="./@lineNumberTxt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:15mm;text-align:center;vertical-align:middle;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="Yr"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:15mm;text-align:center;vertical-align:middle;">
												<xsl:choose>
													<xsl:when test="PassThroughEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="PassThroughEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrSubjToPassiveActyLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PassiveActivityCrAfterLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrFromNnPssvActyAmt"/>
												</xsl:call-template>
											</td>

											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="TotalGeneralBusCreditsAppTxAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrCyovRcptrAdjAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CarryforwardGeneralBusCrAmt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
									
									<xsl:variable name="PartVIGroupCounts" select="count($Form3800Data/*[contains(name(),'AggrgtGrp')])"/>
									<xsl:for-each select="($Form3800Data/Tot8844GBCOrESBCAggrgtAmtGrp)[1]">

										<tr style="font-size:7pt;">
											<xsl:attribute name="class">
												<xsl:choose>
													<xsl:when test="(PartVIGroupCounts) mod 2 = 1">styDepTblRow2</xsl:when>
													<xsl:otherwise>styDepTblRow1</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<td class="styDepTblCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;">
												<span style="font-weight:bold;text-align:right;">
													<xsl:value-of select="($PartVIGroupCounts + 1)"/>
												</span>
											</td>
											<td class="styDepTblCell" style="width:32mm;vertical-align:top;text-align:left;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="./@lineNumberTxt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:15mm;text-align:center;vertical-align:middle;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="Yr"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:15mm;text-align:center;vertical-align:middle;">
												<xsl:choose>
													<xsl:when test="PassThroughEntityEIN">
														<xsl:call-template name="PopulateEIN">
															<xsl:with-param name="TargetNode" select="PassThroughEntityEIN"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="MissingEINReasonCd"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CrSubjToPassiveActyLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PassiveActivityCrAfterLmtAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrFromNnPssvActyAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:choose>
													<xsl:when test="GeneralBusCrCyovRcptrAdjAmt != ''">
														<xsl:call-template name="PopulateAmount">
															<xsl:with-param name="TargetNode" select="GeneralBusCrCyovRcptrAdjAmt"/>
														</xsl:call-template>	
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="PopulateAmount">
															<xsl:with-param name="TargetNode" select="TotalGeneralBusCreditsAppTxAmt"/>
														</xsl:call-template>													
													</xsl:otherwise>
												</xsl:choose>

											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="GeneralBusCrCyovRcptrAdjAmt"/>
												</xsl:call-template>
											</td>
											<td class="styDepTblCell" style="width:28mm;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="CarryforwardGeneralBusCrAmt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
							<br/>
							<br/>
						</xsl:if>
					</div>
				</form>
			</body>
		</html>
	</xsl:template>
	<!-- Template for Part III - Table-->
	<xsl:template name="Part3TableRows">
		<xsl:param name="GroupPath"/>
		<xsl:param name="RowNumber"/>
		<xsl:param name="Dots"/>
		<xsl:param name="ColFormName"/>
		<xsl:param name="ColA"/>
		<xsl:param name="ColB"/>
		<xsl:param name="ColC"/>
		<xsl:param name="ColD"/>
		<xsl:param name="ColE"/>
		<xsl:param name="ColF"/>
		<xsl:param name="ColG"/>
		<xsl:param name="ColH"/>
		<xsl:param name="ColI"/>
		<xsl:param name="ColJ"/>
		<tr style="min-height:4mm;">
			<td class="styLNLeftNumBox" style="width:8mm;padding-left:2.5mm;">
				<xsl:if test="contains($RowNumber,'1') or contains($RowNumber,'2') or contains($RowNumber,'3') or
						 contains($RowNumber,'4') or contains($RowNumber,'5') or contains($RowNumber,'6') or 
						 contains($RowNumber,'7') or contains($RowNumber,'8') or contains($RowNumber,'9')">
					<xsl:attribute name="style">width:8mm;padding-left:1mm;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($RowNumber ='2') or ($RowNumber ='6'))">
					<xsl:attribute name="style">width:8mm;padding-left:1mm;border-bottom:1px solid black;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($RowNumber ='6'))">
					<xsl:attribute name="style">width:8mm;padding-left:1mm;border-bottom:1px solid black; padding-bottom: 6mm;</xsl:attribute>
				</xsl:if>
				<b>
					<xsl:value-of select="$RowNumber"/>
				</b>
			</td>
			<!-- Column with form names -->
			<td class="styIRS3800PartIIITableCell" style="width:50mm;text-align:left;vertical-align:top;">
				<xsl:if test="$RowNumber ='4'">
					<xsl:attribute name="style">text-align:left;width:50mm;vertical-align:top;font-weight:bold;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Specified credits:'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top; font-weight: bold; border-width: 0 0 1px 0;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Add lines 4a-4z'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top; border-width: 1.5px 1px 1px 0;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Add lines 2, 3, and 5'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top; border-width: 1.5px 1px 1px 0;</xsl:attribute>
				</xsl:if>
				 
				<xsl:value-of select="$ColFormName"/>
				<xsl:if test="$GroupPath != ''">
					<xsl:call-template name="SetFormLinkInline">
						<xsl:with-param name="TargetNode" select="$GroupPath"/>
					</xsl:call-template>
				</xsl:if>
				<span class="styDotLn" style="float:right;">
					<xsl:value-of select="$Dots"/>
				</span>
			</td>
			<!-- Column (a) -->
			<td class="styIRS3800PartIIITableCell" style="width:40mm;text-align:left;vertical-align:top; border-right-width: 1px">
				<xsl:choose>
					<xsl:when test="$ColA ='lightgrey'">
						<xsl:attribute name="style">width:8mm;background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColA ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:left;width:50mm;vertical-align:top;border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateText">
							<xsl:with-param name="TargetNode" select="$GroupPath/CYGeneralBusinessCrItemCnt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateText">
							<xsl:with-param name="TargetNode" select="$GroupPath/CYGeneralBusinessCrItemCnt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (b) -->
			<td class="styIRS3800PartIIITableCell" style="width:24mm;text-align:left; vertical-align:top;">
				<xsl:choose>
					<xsl:when test="$ColB ='lightgrey'">
						<xsl:attribute name="style">width:24mm;background-color:lightgrey;</xsl:attribute>
						<xsl:if test="$RowNumber ='5' or $RowNumber ='6'">
							<xsl:attribute name="style">text-align:left;width:50mm;vertical-align:top; vertical-align:top; border-width: 1.5px 1px 1px 0; background-color: lightgrey;</xsl:attribute>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$ColB ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>

					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$GroupPath/TransferRegistrationNum != ''">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$GroupPath/TransferRegistrationNum"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$GroupPath/ElectivePaymentRegistrationNum"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (c) -->
			<td class="styIRS3800PartIIITableCell" style="width:8mm;text-align:center;vertical-align:top; ">
				<xsl:choose>
					<xsl:when test="$ColC ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
						<xsl:if test="$RowNumber ='5' or $RowNumber ='6'">
							<xsl:attribute name="style">text-align:left;width:50mm;vertical-align:top; vertical-align:top; border-width: 1.5px 1px 1px 0; background-color: lightgrey;</xsl:attribute>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$ColC ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>

					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$GroupPath/PassThroughEntityEIN">
								<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$GroupPath/PassThroughEntityEIN"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$GroupPath/MissingEINReasonCd"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="$GroupPath/TransferCreditEntityEIN">
							<br/>
							<xsl:call-template name="PopulateEIN">
								<xsl:with-param name="TargetNode" select="$GroupPath/TransferCreditEntityEIN"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (d) -->
			<td class="styIRS3800PartIIITableCell" style="text-align: right;">
				<xsl:choose>
					<xsl:when test="$ColD ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColD ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm;vertical-align:bottom; border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CrSubjToPassiveActyLmtAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CrSubjToPassiveActyLmtAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (e) -->
			<td class="styIRS3800PartIIITableCell">
				<xsl:choose>
					<xsl:when test="$ColE ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColE ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm;vertical-align:bottom;border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GeneralBusCrFromNnPssvActyAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GeneralBusCrFromNnPssvActyAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (f) -->
			<td class="styIRS3800PartIIITableCell">
				<xsl:choose>
					<xsl:when test="$ColF ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColF ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm;vertical-align:bottom;border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CreditTransferElectionAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CreditTransferElectionAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (g) -->
			<td class="styIRS3800PartIIITableCell">
				<xsl:choose>
					<xsl:when test="$ColG ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColG ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm;vertical-align:bottom;border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/TotalGeneralBusCreditsAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/TotalGeneralBusCreditsAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (h) -->
			<td class="styIRS3800PartIIITableCell">
				<xsl:choose>
					<xsl:when test="$ColH ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColH ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm;vertical-align:bottom; border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GrossElectivePymtElectionAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GrossElectivePymtElectionAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (i) -->
			<td class="styIRS3800PartIIITableCell">
				<xsl:choose>
					<xsl:when test="$ColI ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColI ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm; vertical-align: bottom; border-width: 1.5px 1px 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/TotalGeneralBusCreditsAppTxAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/TotalGeneralBusCreditsAppTxAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (j) -->
			<td class="styIRS3800PartIIITableCell" style="border-right-width:0px;">
				<xsl:choose>
					<xsl:when test="$ColJ ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;border-right-width:0px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColJ ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6'">
						<xsl:attribute name="style">text-align:right;width:50mm;vertical-align:bottom; border-width: 1.5px 0 1px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/NetElectivePymtElectionAmt"/>
						</xsl:call-template>
						
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/NetElectivePymtElectionAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<!-- =============================================================== -->
	<!-- Template for Part IV - Table-->
	<xsl:template name="Part4TableRows">
		<xsl:param name="GroupPath"/>
		<xsl:param name="RowNumber"/>
		<xsl:param name="Dots"/>
		<xsl:param name="ColFormName"/>
		<xsl:param name="ColA"/>
		<xsl:param name="ColB"/>
		<xsl:param name="ColC"/>
		<xsl:param name="ColD"/>
		<xsl:param name="ColE"/>
		<xsl:param name="ColF"/>
		<xsl:param name="ColG"/>
		<xsl:param name="ColH"/>
		<xsl:param name="ColI"/>
		<tr style="min-height:4mm;">
			<td class="styLNLeftNumBox" style="width:8mm;padding-left:2.5mm;">
				<xsl:if test="contains($RowNumber,'1') or contains($RowNumber,'2') or contains($RowNumber,'3') or
						 contains($RowNumber,'4') or contains($RowNumber,'5') or contains($RowNumber,'6') or 
						 contains($RowNumber,'7') or contains($RowNumber,'8') or contains($RowNumber,'9')">
					<xsl:attribute name="style">width:8mm;padding-left:1mm;</xsl:attribute>
				</xsl:if>
				<b>
					<xsl:value-of select="$RowNumber"/>
				</b>
			</td>
			<!-- Column Form Name -->
			<td class="styIRS3800PartIVTableCell" style="width:33mm;text-align:left;vertical-align:top;border-top-width:1px; border-bottom-width: 0px; ">
				<xsl:if test="(($RowNumber ='2') or ($RowNumber ='4'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top;border-top-width:0px;font-weight:bold;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Form 3468, Part II'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top;border-top-width:0px; border-bottom-width: 0px;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Form 5884-A'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top;border-top-width:1px; border-bottom-width: 0px;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Specified credits:'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top; font-weight: bold; border-width: 1px 0px 0px 0px;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Other'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top; border-width: 0px 1px 0px 0px;</xsl:attribute>
				</xsl:if>
				<xsl:if test="(($ColFormName ='Add lines 4a-4z'))">
					<xsl:attribute name="style">width:33mm;text-align:left;vertical-align:top; border-width: 1.7px 1px 0px 0px;</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="$ColFormName"/>
				<span class="styDotLn" style="float:right;">
					<xsl:value-of select="$Dots"/>
				</span>
			</td>
			<!-- Column (a) -->
			<td class="styIRS3800PartIVTableCell" style="text-align: left;">
				<xsl:choose>
					<xsl:when test="$ColA ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColA ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0; text-align: left;</xsl:attribute>
						<xsl:call-template name="PopulateText">
							<xsl:with-param name="TargetNode" select="$GroupPath/CyovGeneralBusinessCrItemCnt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateText">
							<xsl:with-param name="TargetNode" select="$GroupPath/CyovGeneralBusinessCrItemCnt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (b) -->
			<td class="styIRS3800PartIVTableCell" style="width:10mm;text-align:center;">
				<xsl:choose>
					<xsl:when test="$ColB ='lightgrey'">
						<xsl:attribute name="style">width:10mm;background-color:lightgrey; border-right-width: 1px;</xsl:attribute>
						<xsl:if test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
							<xsl:attribute name="style">border-width: 1.5px 1px 0px 0; background-color: lightgrey;</xsl:attribute>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$ColB ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>

					<xsl:otherwise>
						<xsl:call-template name="PopulateText">
							<xsl:with-param name="TargetNode" select="$GroupPath/Yr"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>

			<!-- Column (c) -->
			<td class="styIRS3800PartIVTableCell" style="text-align:center;">
				<xsl:choose>
					<xsl:when test="$ColC ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey; border-right-width: 1px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColC ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0; text-align: center</xsl:attribute>
						<xsl:choose>
							<xsl:when test="$GroupPath/PassThroughEntityEIN">
								<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$GroupPath/PassThroughEntityEIN"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$GroupPath/MissingEINReasonCd">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$GroupPath/MissingEINReasonCd"/>
								</xsl:call-template>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$GroupPath/PassThroughEntityEIN">
								<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$GroupPath/PassThroughEntityEIN"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$GroupPath/MissingEINReasonCd">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$GroupPath/MissingEINReasonCd"/>
								</xsl:call-template>
							</xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (d) -->
			<td class="styIRS3800PartIVTableCell">
				<xsl:choose>
					<xsl:when test="$ColD ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey; border-right-width: 1px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColD ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CrSubjToPassiveActyLmtAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CrSubjToPassiveActyLmtAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (e) -->
			<td class="styIRS3800PartIVTableCell" >
				<xsl:choose>
					<xsl:when test="$ColE ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey; border-right-width: 1px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColE ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/PassiveActivityCrAfterLmtAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/PassiveActivityCrAfterLmtAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (f) -->
			<td class="styIRS3800PartIVTableCell" style="border-right-width:1px;">
				<xsl:choose>
					<xsl:when test="$ColF ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey; border-right-width: 1px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColF ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GeneralBusCrFromNnPssvActyAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GeneralBusCrFromNnPssvActyAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (g) -->
			<td class="styIRS3800PartIVTableCell" style="border-right-width:1px;">
				<xsl:choose>
					<xsl:when test="$ColG ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;border-right-width:1px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColG ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/TotalGeneralBusCreditsAppTxAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/TotalGeneralBusCreditsAppTxAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (h) -->
			<td class="styIRS3800PartIVTableCell" style="border-right-width:1px;">
				<xsl:choose>
					<xsl:when test="$ColH ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;border-right-width:1px;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColH ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 1px 0px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GeneralBusCrCyovRcptrAdjAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/GeneralBusCrCyovRcptrAdjAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- Column (i) -->
			<td class="styIRS3800PartIVTableCell" style="border-right-width:0;">
				<xsl:choose>
					<xsl:when test="$ColI ='lightgrey'">
						<xsl:attribute name="style">background-color:lightgrey;border-right-width:0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$ColI ='nofill'">
						<xsl:attribute name="style">border-right-width: 0;</xsl:attribute>
					</xsl:when>
					<xsl:when test="$RowNumber ='5' or $RowNumber ='6' or $RowNumber ='7'">
						<xsl:attribute name="style">border-width: 1.5px 0px 0px 0;</xsl:attribute>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CarryforwardGeneralBusCrAmt"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$GroupPath/CarryforwardGeneralBusCrAmt"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<!-- Template for Part V - Blank Rows-->
	<xsl:template name="PartVBlankRows">
		<xsl:param name="numRows" select="count(15 - $Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')])"/>
		<xsl:if test="$numRows &gt; 0">
			<tr style="min-height:4mm;">
				<td class="styTableCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;padding-bottom:0.5mm;border-bottom-width:0px;">
					<xsl:if test="($numRows = 1)">
						<xsl:attribute name="style">width:12mm;vertical-align:top;text-align:right;padding-right:5mm;</xsl:attribute>
					</xsl:if>
					<span class="styLNLeftNumBox">
						<xsl:value-of select="15 - ($numRows) + 1"/>
					</span>
				</td>
				<td class="styTableCell" style="width:26mm;vertical-align:top;text-align:left;">
					<xsl:if test="(15 - ($numRows) + 1) = 1">
						<xsl:call-template name="PopulateAdditionalDataTableMessage">
							<xsl:with-param name="TargetNode" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
							<xsl:with-param name="ShortMessage" select="'true'"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<td class="styTableCell" style="width:36mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"><span style="float: left;">(</span><span style="float: right;">)</span></td>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="border-right:none;"><span style="float: left;">(</span><span style="float: right;">)</span></td>
			</tr>
			<xsl:call-template name="PartVBlankRows">
				<xsl:with-param name="numRows" select="$numRows - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="PartV2BlankRows">
		<xsl:param name="numRows" select="count(15 - $Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')])"/>
		<xsl:if test="$numRows &gt; 0">
			<tr style="min-height:4mm;">
				<td class="styTableCell" style="width:12mm;vertical-align:top;text-align:right;padding-right:5mm;padding-bottom:0.5mm;border-bottom-width:0px;">
					<xsl:if test="($numRows = 1)">
						<xsl:attribute name="style">width:12mm;vertical-align:top;text-align:right;padding-right:5mm;</xsl:attribute>
					</xsl:if>
					<span class="styLNLeftNumBox">
						<xsl:value-of select="15 - ($numRows) + 1"/>
					</span>
				</td>
				<td class="styTableCell" style="width:26mm;vertical-align:top;text-align:left;">
					<xsl:if test="(15 - ($numRows) + 1) = 1">
						<xsl:call-template name="PopulateAdditionalDataTableMessage">
							<xsl:with-param name="TargetNode" select="$Form3800Data/GBCBreakdownCYAggrgtAmtGrp/*[contains(name(),'Grp')]"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<td class="styTableCell" style="width:36mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="border-right:none;"/>
			</tr>
			<xsl:call-template name="PartV2BlankRows">
				<xsl:with-param name="numRows" select="$numRows - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- Part VI Blank Rows -->
	<xsl:template name="PartVIBlankRows">
		<xsl:param name="numRows" select="count(35 - $Form3800Data/*[contains(name(),'AggrgtGrp') or contains(name(),'AggrgtAmtGrp')])"/>
		<xsl:if test="$numRows &gt; 0">
			<tr style="min-height:4mm;">
				<td class="styTableCell" style="width:12mm;border:none;vertical-align:top;text-align:right;padding-right:5mm;padding-bottom:0.5mm;">
					<xsl:if test="($numRows = 1)">
						<xsl:attribute name="style">width:12mm;border-right:none;vertical-align:top;text-align:right;padding-right:5mm;</xsl:attribute>
					</xsl:if>
					<span class="styLNLeftNumBox">
						<xsl:value-of select="35 - ($numRows) + 1"/>
					</span>
				</td>
				<td class="styTableCell" style="width:32mm;vertical-align:top;text-align:left;">
					<xsl:if test="(35 - ($numRows) + 1) = 1">
						<xsl:call-template name="PopulateAdditionalDataTableMessage">
							<xsl:with-param name="TargetNode" select="$Form3800Data/*[contains(name(),'AggrgtGrp') or contains(name(),'AggrgtAmtGrp')]"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<td class="styTableCell" style="width:15mm;"/>
				<td class="styTableCell" style="width:15mm;"/>
				<td class="styTableCell" style="width:26mm;"/>
				<td class="styTableCell" style="width:28mm;"/>
				<td class="styTableCell" style="width:28mm;"/>
				<td class="styTableCell" style="width:28mm;"/>
				<td class="styTableCell" style="width:28mm;"/>
				<td class="styTableCell" style="border-right:none;"/>
			</tr>
			<xsl:call-template name="PartVIBlankRows">
				<xsl:with-param name="numRows" select="$numRows - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
