<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;"> 
	<!ENTITY mdash "&#8212;">	
]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="PopulateTemplate.xsl"/>
	<xsl:include href="CommonPathRef.xsl"/>
	<xsl:include href="AddHeader.xsl"/>
	<xsl:include href="AddOnTable.xsl"/>
	<xsl:include href="IRS1120RICStyle.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:param name="FormData" select="$RtnDoc/IRS1120RIC"/>
	<xsl:param name="IRS1120RICScheduleA" select="$RtnDoc/IRS1120RIC/IRS1120RICScheduleA"/>
	<xsl:param name="IRS1120RICScheduleJ" select="$RtnDoc/IRS1120RIC/IRS1120RICScheduleJ"/>
	<xsl:param name="IRS1120SchedulePH" select="$RtnDoc/IRS1120RIC/IRS1120SchedulePH"/>
	<xsl:param name="Section988IncomeOrLossStatement" select="$RtnDoc/IRS1120RIC/Section988IncomeOrLossStatement"/>
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html lang="EN-US">
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($FormData)"/>
					</xsl:call-template>
				</title>
				<!-- No Browser Caching  -->
				<meta http-equiv="Pragma" content="no-cache"/>
				<meta http-equiv="Cache-Control" content="no-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private"/>
				<!-- Define Character Set -->
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
				<meta name="Description" content="IRS Form 1120RIC"/>
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
				<xsl:call-template name="InitJS"/>
				<style type="text/css">
					<xsl:if test="not($Print) or $Print=''">
					<xsl:call-template name="IRS1120RICStyle"/>
					<xsl:call-template name="AddOnStyle"/>
					</xsl:if>
				</style>
				<xsl:call-template name="GlobalStylesForm"/>
			</head>
			<body class="styBodyClass" style="width:187mm">
				<form name="Form1120RIC">
					<xsl:call-template name="DocumentHeader"/>
					<div class="styBB" style="width:187mm;">
						<div class="styFNBox" style="width:30mm;height:18mm;">
                            Form <span class="styFN" style="font-size:11pt;">1120-RIC</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData"/>
							</xsl:call-template>
							<br/>
							<br/>
							<span class="styAgency">Department of the Treasury</span>
							<br/>
							<span class="styAgency">Internal Revenue Service</span>
						</div>
						<div class="styFTBox" style="width:128mm;height:18mm;text-align:center;">
							<div class="styFMT" style="font-size:11pt;padding-top:1.5mm;">U.S. Income Tax Return for<br/>
								Regulated Investment Companies 
							</div>
							<br/>
							<span style="font-weight:bold;"> For calendar year 2025 or tax year beginning
								<span style="width:12mm;border-bottom:1px dashed black;">
									<xsl:call-template name="PopulateMonthDayYear">
										<xsl:with-param name="TargetNode" select="$FormData/TaxPeriodBeginDt"/>
									</xsl:call-template>
								</span>, 2025, and ending 
								<span style="width:12mm;border-bottom:1px dashed black;">
									<xsl:call-template name="PopulateMonthDayYear">
										<xsl:with-param name="TargetNode" select="$FormData/TaxPeriodEndDt"/>
									</xsl:call-template>
								</span>, 
								<span style="width:7mm;border-bottom:1px dashed black;">
									<xsl:call-template name="PopulateReturnHeaderTaxYear"/>
										<!--<xsl:with-param name="TargetNode" select="$FormData/TaxPeriodEndDt"/>
									</xsl:call-template>-->
								</span>
							</span>
							<br/>
							<span style="font-weight:bold;">
								Go to  			
								<a style="text-decoration:none;color:black;" href="http://www.irs.gov/form1120RIC" title="Link to IRS.gov">
									<i>www.irs.gov/Form1120RIC</i>
								</a> for instructions and the latest information.
							</span>						
						</div>
						<div class="styTYBox" style="width:28mm;height:18mm;">
							<div class="styOMB" style="height:4mm;">OMB No. 1545-0123</div>
							<div class="styTY" style="height:11mm;padding-top:2mm;">20<span class="styTYColor">25</span>
							</div>
						</div>
					</div>				
					<div style="width:187mm;float:left;clear:left;">
						<!-- Line A -->
						<div style="width:33.3mm;float:left;clear:left;">
							<div class="styComType" style="width:33.3mm;border-bottom-width: 0px;border-bottom:1px solid black;height:15mm;">
								<div class="styBoldText" style="height:3mm;width:4mm;float:left;clear:none;">A</div>
								<div class="styGenericDiv" style="height:15mm;width:26mm">Year of RIC status <br/> election
									<br/><br/>
									<xsl:call-template name="PopulateYear">
										<xsl:with-param name="TargetNode" select="$FormData/RICStatusElectionYr"/>
									</xsl:call-template>
								</div>
							</div>
							<!-- Line B -->
							<div class="styComType" style="width:33.3mm;border-bottom:0px;height:15mm;">
								<div class="styBoldText" style="height:3mm;width:4mm;float:left;clear:none;">B</div>
								<div class="styGenericDiv" style="height:15mm;width:29mm"> Date fund was established <br/> (see instructions)
									<br/><br/>
									<xsl:call-template name="PopulateMonthDayYear">
										<xsl:with-param name="TargetNode" select="$FormData/EstablishedDt"/>
									</xsl:call-template>
								</div>
							</div>
						</div>
						<!-- Name and Address -->
						<div class="styLblNameAddr" style="width:110mm;height:auto;border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-right-width: 1px;">
							<div class="styNameAddr" style="width:110mm;height:10mm;border-left-width:1px;padding-left:2mm;">
								Name of fund<br/>
								<xsl:call-template name="PopulateReturnHeaderFiler">
									<xsl:with-param name="TargetNode">BusinessNameLine1Txt</xsl:with-param>
								</xsl:call-template>
								<br/>
								<xsl:call-template name="PopulateReturnHeaderFiler">
									<xsl:with-param name="TargetNode">BusinessNameLine2Txt</xsl:with-param>
								</xsl:call-template>
							</div>
							<!-- return header Adress box -->
							<div style="width:110mm; border-right-width:1px solid black;">
								<div class="styNameAddr" style="width:80mm;height:10mm;border-left-width:1px;padding-left:2mm;border-right-width:1px;">
									Number and street.(If a P.O. box, see instructions.)<br/>
									<!-- Address -->
									<!-- US Address -->
									<xsl:choose>
										<xsl:when test="$FormData/USAddress/AddressLine1Txt!=''">
											<xsl:call-template name="PopulateReturnHeaderFiler">
												<xsl:with-param name="TargetNode">AddressLine1Txt</xsl:with-param>
											</xsl:call-template>
											<br/>
											<xsl:call-template name="PopulateReturnHeaderFiler">
												<xsl:with-param name="TargetNode">AddressLine2Txt</xsl:with-param>
											</xsl:call-template>
											<br/>
										</xsl:when>
										<xsl:otherwise>
											<!-- Foreign Address -->									
											<xsl:call-template name="PopulateReturnHeaderFiler">
												<xsl:with-param name="TargetNode">AddressLine1Txt</xsl:with-param>
											</xsl:call-template>
											<span class="styTableCellPad"/>
											<br/>
											<xsl:call-template name="PopulateReturnHeaderFiler">
												<xsl:with-param name="TargetNode">AddressLine1Txt</xsl:with-param>
											</xsl:call-template>
											<span class="styTableCellPad"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>
								<div class="styNameAddr" style="width:30mm;height:10mm;padding-left:2mm;">
									Room or suite no.
									<br/>
									<!--<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/ForeignAddress/AddressLine2Txt"/>
									</xsl:call-template>-->
								</div>
							</div>
							<div style="width:110mm; border-right-width:1px solid black;">
								<div class="styNameAddr" style="width:35mm;height:10mm;padding-left:2mm;border-left-width:1px;border-bottom-width:0px;">
									City or town
									<br/>
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">CityNm</xsl:with-param>
									</xsl:call-template>
								</div>
								<div class="styNameAddr" style="width:35mm;height:10mm;padding-left:2mm;border-left-width:1px;border-bottom-width:0px;">
									State
									<br/>
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">StateAbbreviationCd</xsl:with-param>
									</xsl:call-template>
									<br/>
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">ProvinceOrStateNm</xsl:with-param>
									</xsl:call-template>	
								</div>															
								<div class="styNameAddr" style="width:35mm;height:10mm;padding-left:2mm;border-left-width:1px;border-bottom-width:0px;">
									ZIP Code
									<br/>
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">ZIPCd</xsl:with-param>
									</xsl:call-template>
									<br/>
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">ForeignPostalCd</xsl:with-param>
									</xsl:call-template>
								</div>
							</div>
						</div>
						<!-- Line C-->
						<div class="styEINBox" style="padding-left:0.5mm;font-weight:normal;height:9.8mm;">
							<span class="styBoldText" style="padding-left:1mm;padding-right:1mm">C</span>
							<strong>Employer identification number</strong><br/>
							<xsl:call-template name="PopulateReturnHeaderFilerTIN"/>
						</div>
						<!-- Line D Date -->
						<div class="styEINDateAssets" style="width:43mm;height:20mm;border-bottom-width:0px;border-top-width:1px;">
							<span class="styBoldText" style="padding-right:1mm">D </span>Total assets (see instructions) <br/>
							$<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalAssetsAmt"/>
							</xsl:call-template>
						</div>
					</div>					
					<!-- Line E -->
					<div class="styBB" style="width:187mm;border-right-width:0px; border-top-width:1px;">
						<!-- Line E1 -->
						<div style="float:left;clear:none;padding-right:3mm;padding-top:1mm;"><strong>E</strong>
							<span style="padding-left:3mm">Check applicable boxes:</span>
						</div>
						<div style="padding-right:5mm;">
							<span style="padding-bottom:.5mm;padding-right:1mm;"><strong>(1)</strong></span>
							<input type="checkbox" alt="Final Return" class="styCkbox" aria-label="Final Return">
								<xsl:call-template name="PopulateCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/FinalReturnInd"/>
									<xsl:with-param name="BackupName">IRS1120RICFinalReturnInd</xsl:with-param>
								</xsl:call-template>
							</input>
							Final return
						</div>
						<!-- Line E2 -->
						<div style="padding-right:5mm;">
							<span style="padding-bottom:.5mm;padding-right:1mm;"><strong>(2)</strong></span>
							<input type="checkbox" alt="Name Change" class="styCkbox" aria-label="Name Change">
								<xsl:call-template name="PopulateCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/NameChangeInd"/>
									<xsl:with-param name="BackupName">IRS1120RICNameChangeInd</xsl:with-param>
								</xsl:call-template>
							</input>
							Name change
						</div>
						<!-- Line E3 -->
						<div style="padding-right:5mm;">
							<span style="padding-bottom:.5mm;padding-right:1mm;"><strong>(3)</strong></span>
							<input type="checkbox" alt="Address Change" class="styCkbox" aria-label="Address Change">
								<xsl:call-template name="PopulateCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AddressChangeInd"/>
									<xsl:with-param name="BackupName">IRS1120RICAddressChangeInd</xsl:with-param>
								</xsl:call-template>
							</input>
							Address change
						</div>
						<!-- Line E4 -->
						<div style="padding-right:5mm;">
							<span style="padding-bottom:.5mm;padding-right:1mm;"><strong>(4)</strong></span>
							<input type="checkbox" alt="Amended Return" class="styCkbox" aria-label="Amended Return">
								<xsl:call-template name="PopulateCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AmendedReturnInd"/>
									<xsl:with-param name="BackupName">IRS1120RICAmendedReturnInd</xsl:with-param>
								</xsl:call-template>
							</input>
							Amended return 
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/AmendedReturnInd"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line F -->
					<div class="styBB" style="width:187mm;border-right-width:0px;">
						<div style="float:left;clear:none;"><strong>F</strong>
							<span style="padding-left:3mm; font-size:6.9pt;">
							Check if the fund is a personal holding company (attach Sch. PH) or if the fund is not in compliance with Regs. sec. 1.852-6 for this tax year
							</span>
							<input type="checkbox" alt="Personal Holding Company" class="styCkbox" aria-label="Personal Holding Company">
								<xsl:call-template name="PopulateCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/PersonalHoldingCompanyInd"/>
									<xsl:with-param name="BackupName">IRS1120RICPersonalHoldingCompanyInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/PersonalHoldingCompanyInd"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Page 1 Part I -->
					<div class="styBB" style="width:187mm;border-right-width:0px;">
						<div class="styPartDesc" style="padding-left:0px;"><strong>Part I-Investment Company Taxable Income</strong> (see instructions)</div>
					</div>
					<!-- Income -->
					<div class="styBB" style="width:187mm;">
						<div class="styIRS1120VTImageBox" style="height:36mm;width:19px;padding-top:14mm">
							<img src="{$ImagePath}/1120RIC_Income.gif" alt="Vertical Income"/>
						</div>
						<div style="width:000mm;float:right;clear:none;"/>
						<!-- Part I line 1 -->
						<div class="styLNLeftNumBox" style="padding-left: 3.5mm">1</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Dividends</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.............................</span>
						</div>
						<div class="styLNRightNumBox" style="float:middle;">1</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotDividendsInclusionsRcvdAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 2 -->
						<div class="styLNLeftNumBox" style="padding-left:3.5mm">2</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Interest</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.............................</span>
						</div>
						<div class="styLNRightNumBox" style="float:middle;">2</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TaxableInterestAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 3 -->
						<div class="styLNLeftNumBox" style="padding-left:3.5mm">3</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Net foreign currency gain or (loss) from section 988 transactions (attach statement)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.....</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/ForeignCurrencyNetGainLossAmt"/>
							</xsl:call-template>
						</div>					
						<div class="styLNRightNumBox" style="float:middle;">3</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/ForeignCurrencyNetGainLossAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 4 -->
						<div class="styLNLeftNumBox" style="padding-left:3.5mm">4</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Payments with respect to securities loans</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">...................</span>
						</div>
						<div class="styLNRightNumBox" style="float:middle;">4</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/SecurityLoansPaymentsAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 5 -->
						<div class="styLNLeftNumBox" style="height:8mm;padding-left: 3.5mm">5</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Excess of net short-term capital gain over net long-term capital loss from Schedule D (Form 1120), line <br/></span>
							<span style="float:left;clear:none;">16 (attach Schedule D (Form 1120))</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">...................</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainNetIncomeAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="height:8mm;float:middle;padding-top:4mm;">5</div>
						<div class="styLNAmountBox" style="height:8mm;width:32.9mm;padding-top:4mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainNetIncomeAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 6 -->
						<div class="styLNLeftNumBox" style="padding-left: 3.5mm">6</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Net gain or (loss) from Form 4797, Part II, line 17 (attach Form 4797)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.........</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TotalOrdinaryGainLossAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="float:middle;">6</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalOrdinaryGainLossAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 7 -->
						<div class="styLNLeftNumBox" style="padding-left: 3.5mm">7</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Other income (see instructions-attach statement)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">...............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherIncomeAmt"/>
							</xsl:call-template>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherIncomeAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="float:middle;">7</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OtherIncomeAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 8 -->
						<div class="styLNLeftNumBox" style="padding-left:3.5mm">8</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;"><strong>Total income.</strong> Add lines 1 through 7</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">....................</span>
						</div>
						<div class="styLNRightNumBox" style="float:middle;border-bottom-width:0px;">8</div>
						<div class="styLNAmountBox" style="width:32.9mm;border-bottom-width:0px;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalIncomeAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Deduction -->
					<div class="styBB" style="width:187mm;">
						<div class="styIRS1120VTImageBox" style="height:80mm;width:19px;padding-top:15mm;">
							<img src="{$ImagePath}/1120RIC_Deductions.gif" alt="Vertical Deductions (See instructions)"/>
						</div>
						<div style="width:000mm;float:right;clear:none;"/>
						<!-- Part I line 9 -->
						<div class="styLNLeftNumBox" style="padding-left: 3.5mm">9</div>
						<div class="styLNDesc" style="width:133mm;padding-left:1mm">
							<span style="float:left;clear:none;">Compensation of officers (see instructions-attach Form 1125-E)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">...........</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OfficersCompensationAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="float:middle;">9</div>
						<div class="styLNAmountBox" style="width:32.9mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OfficersCompensationAmt"/>
							</xsl:call-template>
						</div>
						<!-- Part I line 10 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">10</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Salaries and wages (less employment credits)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..................</span>
							</div>
							<div class="styLNRightNumBox">10</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/SalariesAndWagesAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 11 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">11</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Rents</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.............................</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/TotalRentOrLeaseExpenseAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox">11</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalRentOrLeaseExpenseAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 12 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">12</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Taxes and licenses</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..........................</span>
							</div>
							<div class="styLNRightNumBox">12</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TaxesAndLicensesAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 13 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">13</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Interest (see instructions)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.......................</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/InterestDeductionAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox">13</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/InterestDeductionAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 14 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">14</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Depreciation (attach Form 4562)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.....................</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/DepreciationAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox">14</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/DepreciationAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 15 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">15</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Advertising</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">............................</span>
							</div>
							<div class="styLNRightNumBox">15</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/AdvertisingAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 16 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">16</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Registration fees</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">...........................</span>
							</div>
							<div class="styLNRightNumBox">16</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/RegistrationFeesAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 17 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">17</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Insurance</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.............................</span>
							</div>
							<div class="styLNRightNumBox">17</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/InsuranceAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 18 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">18</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Accounting and legal services</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.......................</span>
							</div>
							<div class="styLNRightNumBox">18</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/AccountingAndLegalServicesAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 19 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">19</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Management and investment advisory fees</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">...................</span>
							</div>
							<div class="styLNRightNumBox">19</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/MgmtAndInvstAdvisoryFeesAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 20 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">20</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Transfer agency, shareholder servicing, and custodian fees and expenses</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.........</span>
							</div>
							<div class="styLNRightNumBox">20</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/FeesAndExpensesAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 21 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">21</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Reports to shareholders</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">........................</span>
							</div>
							<div class="styLNRightNumBox">21</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/ReportsToShareholdersAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 22 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">22</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Other deductions (see instructions-attach statement)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.............</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/OtherDeductionsAmt"/>
								</xsl:call-template>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/OtherDeductionsAmt"/>
								</xsl:call-template>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/OtherDeductionsAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox">22</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/OtherDeductionsAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 23 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">23</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;"><strong>Total deductions.</strong> Add lines 9 through 22</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">...................</span>
							</div>
							<div class="styLNRightNumBox">23</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalDeductionAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 24 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">24</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;">Taxable income before dividends paid and section 851 deductions. Subtract line 23 from line 8</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">...</span>
							</div>
							<div class="styLNRightNumBox">24</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TaxableIncomeBfrSect851DedAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 25 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">25</div>
							<!-- Part I Line 25a -->
							<div class="styLNDesc" style="width:95mm;">
								<span style="float:left;clear:none;"><strong>Less: a</strong></span>
								<span style="padding-left:3mm;">Deduction for dividends paid (Schedule A, line 8a)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">....</span>
							</div>
							<div class="styLNRightNumBox">25a</div>
							<div class="styLNAmountBox" style="width:29mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$IRS1120RICScheduleA/TotalDeductionDividendsPaidAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:32.9mm;border-bottom:0px;"></div>
							<!-- Part I Line 25b -->
							<div class="styLNDesc" style="width:103mm;height:8mm;">
								<span style="float:left;clear:none;padding-left:16mm;"><strong>b</strong></span>
								<span style="padding-left:3mm;">Deductions for tax imposed under sections 851 (d)(2) and 851(i) </span>
								<br />
								<span style="padding-left:3mm;padding-left:21mm;">(Schedule J, lines 1c and 1d)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..........</span>
							</div> 
							<div class="styLNRightNumBox" style="border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:29mm;border-bottom:0px;"></div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:32.9mm;border-bottom:0px;"></div>
							<div class="styLNRightNumBox">25b</div>
							<div class="styLNAmountBox" style="width:29mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/Section851d2iDeductionsAmt"/>
								</xsl:call-template>
							</div>
							<!-- Part I Line 25c -->
							<div class="styLNRightNumBox">25c</div>
							<div class="styLNAmountBox" style="width:32.9mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotDivPdSections851DedAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 26 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">26</div>
							<div class="styLNDesc" style="width:132mm;">
								<span style="float:left;clear:none;"><strong>Investment company taxable income.</strong> Subtract line 25c from line 24</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.........</span>
							</div>
							<div class="styLNRightNumBox" style="border-bottom-width:0px;">26</div>
							<div class="styLNAmountBox" style="width:32.9mm;border-bottom-width:0px;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/RICTaxableIncomeAmt"/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<!--<br class="pageEnd"/>-->
					<!-- Signature Section -->
					<table border="0" cellspacing="0" cellpadding="0" style="width:187mm;font-size:6pt;clear:all;">
						<tr>
							<td rowspan="3" style="width:12mm;font-size: 11pt;font-weight:bold;border-right:1px solid black;border-bottom:1px solid black;">Sign Here</td>
							<td colspan="6" style="padding-left:1mm;padding-bottom:1mm;">Under penalties of perjury, I declare that I have examined this return, including accompanying schedules and statements, and to the best of my knowledge and belief, it is true, correct, and complete. Declaration of preparer (other than taxpayer) is based on all information of which preparer has any knowledge. </td>
						</tr>
						<tr>
							<td rowspan="2" style="border-bottom:1px solid black;">
							</td>
							<td style="width:60mm;border-right:1px solid black;border-bottom:1px solid black;vertical-align:bottom;">
								<xsl:call-template name="PopulateReturnHeaderOfficer">
									<xsl:with-param name="TargetNode">PersonNm</xsl:with-param>
								</xsl:call-template>
								<span style="width:1px;"/>
							</td>
							<td style="width:20mm;border-bottom:1px solid black;vertical-align:bottom;padding-left:.5mm;">
								<xsl:call-template name="PopulateReturnHeaderOfficer">
									<xsl:with-param name="TargetNode">SignatureDt</xsl:with-param>
								</xsl:call-template>
							</td>
							<td rowspan="2" style="border-bottom:1px solid black;padding-left:1mm;">
							</td>
							<td style="width:52mm;border-bottom:1px solid black;vertical-align:bottom;">
								<xsl:call-template name="PopulateReturnHeaderOfficer">
									<xsl:with-param name="TargetNode">PersonTitleTxt</xsl:with-param>
								</xsl:call-template>
							</td>
							<td rowspan="2" style="width:40mm;border-bottom:1px solid black;padding-bottom:1mm;">
								<div class="styGenericDiv" style="width:2px;"/>
								<div style="border-right:3px solid black;border-left:3px solid black;border-bottom:3px solid black;border-top:3px solid black;float:right;padding-left:1mm;" class="styGenericDiv">		
May the IRS discuss this return<br/> with the preparer shown below?. <br/>See instructions.
<input class="styCkbox" alt="May IRS Discuss Return With Prep Yes" type="checkbox" name="Checkbox" id="dummyidyes" style="width:3mm;">
										<xsl:call-template name="PopulateReturnHeaderOfficer">
											<xsl:with-param name="TargetNode">AuthorizeThirdPartyYesCheckbox</xsl:with-param>
											<xsl:with-param name="BackupName">May IRS Discuss Return With Prep</xsl:with-param>
										</xsl:call-template>
									</input>
									<label for="dummyidyes">
										<xsl:call-template name="PopulateReturnHeaderOfficer">
											<xsl:with-param name="TargetNode">AuthorizeThirdPartyYesLabel</xsl:with-param>
											<xsl:with-param name="BackupName">May IRS Discuss Return With Prep</xsl:with-param>
										</xsl:call-template>Yes
									</label>
									<input class="styCkbox" alt="May IRS Discuss Return With Prep No" type="checkbox" name="Checkbox" id="dummyidno" style="width:2.5mm;">
										<xsl:call-template name="PopulateReturnHeaderOfficer">
											<xsl:with-param name="TargetNode">AuthorizeThirdPartyNoCheckbox</xsl:with-param>
											<xsl:with-param name="BackupName">May IRS Discuss Return With Prep</xsl:with-param>
										</xsl:call-template>
									</input>
									<label for="dummyidno">
										<xsl:call-template name="PopulateReturnHeaderOfficer">
											<xsl:with-param name="TargetNode">AuthorizeThirdPartyNoLabel</xsl:with-param>
											<xsl:with-param name="BackupName">May IRS Discuss Return With Prep</xsl:with-param>
										</xsl:call-template>No
									</label>
								</div>
							</td>
						</tr>
						<tr>
							<td style="border-bottom:1px solid black;vertical-align:top;padding-left:1mm;">Signature of officer</td>
							<td style="border-bottom:1px solid black;vertical-align:top;">Date</td>
							<td style="border-bottom:1px solid black;vertical-align:top;">Title</td>
						</tr>
					</table>
					<div class="styBB" style="width:187mm;font-size:6pt;">
						<div style="width:18mm;height:15mm;padding-top:4mm;padding-bottom:4mm;float:left;clear:none;">
							<span class="styMainTitle" style="font-size:11pt;">
									Paid
									Preparer
									Use Only
									</span>
						</div>
						<div style="width:169mm;float:left;clear:none;">
							<div style="width:169mm;float:left;clear:none;border-style:solid;border-color:black;border-width:0px 0px 1px 0px;">
								<div class="styLNDesc" style="height:8mm;width:53mm;padding-top:0mm;border-right:1px solid black;border-left:1px solid black;padding-left:1mm;">
								  Preparer's name<br/>
									<br/>
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$RtnHdrData/PreparerPersonGrp/PreparerPersonNm"/>
										<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpPreparerPersonNm</xsl:with-param>
									</xsl:call-template>
								</div>
								<div class="styLNDesc" style="height:8mm;width:53mm;padding-top:0mm;border-right:1px solid black;padding-left:1mm;">
								Preparer's signature
							</div>
								<div class="styLNDesc" style="height:8mm;width:20mm;border-right:1px solid black;padding-top:0mm;padding-left:1mm;">Date <br/>
									<br/>
									<xsl:call-template name="PopulateReturnHeaderPreparer">
										<xsl:with-param name="TargetNode">PreparationDt</xsl:with-param>
										<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpPreparationDt</xsl:with-param>
									</xsl:call-template>
								</div>
								<div class="styLNDesc" style="height:8mm;width:18mm;border-right:1px solid black;padding-top:0mm;vertical-align:top;padding-bottom:0mm;padding-left:1mm;">
									<label>
										<xsl:call-template name="PopulateLabel">
											<xsl:with-param name="TargetNode" select="$RtnHdrData/PreparerPersonGrp/SelfEmployedInd"/>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpSelfEmployed</xsl:with-param>
										</xsl:call-template>
										Check 
										<input class="styCkbox" alt="Preparer Person Grp Self Employed" type="checkbox" style="width:4mm;">
											<xsl:call-template name="PopulateCheckbox">
												<xsl:with-param name="TargetNode" select="$RtnHdrData/PreparerPersonGrp/SelfEmployedInd"/>
												<xsl:with-param name="BackupName">$RtnHdr Data Preparer PersonGrpSelfEmployed</xsl:with-param>
											</xsl:call-template>
										</input>
										<span style="width:4.5px;"/>if<br/>self-employed
									</label>
								</div>
								<div class="styLNDesc" style="height:6mm;width:18mm;padding-top:0mm;padding-left:1mm;">PTIN
                				<br/>
									<span style="width:6mm;"/>
									<xsl:choose>
										<xsl:when test="$RtnHdrData/PreparerPersonGrp/SSN">
											<xsl:call-template name="PopulateReturnHeaderPreparer">
												<xsl:with-param name="TargetNode">SSN</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpSSN</xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="PopulateReturnHeaderPreparer">
												<xsl:with-param name="TargetNode">PTIN</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpPTIN</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</div>
							<div style="width:169mm;float:left;clear:none;border-style:solid;border-color:black;border-width:0px 0px 1px 0px;">
								<div class="styLNDesc" style="height:auto;width:126mm;border-right:1px solid black;border-left:1px solid black;padding-left:1mm;">
									<span class="styGenericDiv">Firm's name 
									<span style="width:2.2mm;"/>
										<span style="width:4px;"/>
									</span>
									<div class="styGenericDiv" style="padding-right:.5mm;">
										<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
											<xsl:with-param name="TargetNode">BusinessNameLine1Txt</xsl:with-param>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpPreparerFirmBusinessNameBusinessName1
										</xsl:with-param>
										</xsl:call-template>
										<br/>
										<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
											<xsl:with-param name="TargetNode">BusinessNameLine2Txt</xsl:with-param>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpPreparerFirmBusinessNameBusinessName2
										</xsl:with-param>
										</xsl:call-template>
									</div>
								</div>
								<div class="styLNDesc" style="height:6mm;width:32mm;padding-left:1mm;">Firm's EIN
									<span style="width:4px;"/>
									<xsl:if test="$RtnHdrData/PreparerFirmGrp/PreparerFirmEIN">
										<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
											<xsl:with-param name="TargetNode">EIN</xsl:with-param>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpPreparerFirmEIN</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
									<xsl:if test="$RtnHdrData/PreparerFirmGrp/MissingEINReasonCd">
										<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
											<xsl:with-param name="TargetNode">MissingEINReason</xsl:with-param>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpMissingEINReasonCd</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</div>
							</div>
							<div style="width:164mm;float:left;clear:none;">
								<div class="styLNDesc" style="width:126mm;border-right:1px solid black;border-left:1px solid black;padding-left:1mm;height:auto;">
									<div class="styGenericDiv" style="padding-right:.5mm;">Firm's address 
									</div>
									<div class="styGenericDiv" style="padding-right:.5mm;">
										<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
											<xsl:with-param name="TargetNode">AddressLine1Txt</xsl:with-param>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpAddressLine1</xsl:with-param>
										</xsl:call-template>
										<br/>
										<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
											<xsl:with-param name="TargetNode">AddressLine2Txt</xsl:with-param>
											<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpAddressLine2</xsl:with-param>
										</xsl:call-template>
										<br/>
										<xsl:if test="(($RtnHdrData/PreparerFirmGrp/PreparerUSAddress!='') and ($Location='RET'))">
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">CityNm</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpUSAddressCity</xsl:with-param>
											</xsl:call-template>,
											<span style="width:2px;"/>
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">StateAbbreviationCd</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpUSAddressState</xsl:with-param>
											</xsl:call-template>,
											<span style="width:2px;"/>
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">ZIPCd</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpUSAddressZip</xsl:with-param>
											</xsl:call-template>
										</xsl:if>
										<xsl:if test="(($RtnHdrData/PreparerFirmGrp/PreparerForeignAddress!='') and ($Location='RET'))">
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">CityNm</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpForeignAddressCity</xsl:with-param>
											</xsl:call-template>,
											<span style="width:2px;"/>
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">ProvinceOrStateNm</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpForeignProvinceOrState</xsl:with-param>
											</xsl:call-template>,
											<span style="width:2px;"/>
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">ForeignPostalCd</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpForeignPostalCd</xsl:with-param>
											</xsl:call-template>,
											<span style="width:2px;"/>
											<xsl:call-template name="PopulateReturnHeaderPreparerFirm">
												<xsl:with-param name="TargetNode">CountryCd</xsl:with-param>
												<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpFirmGrpForeignCountry</xsl:with-param>
											</xsl:call-template>
										</xsl:if>
									</div>
								</div>
								<div class="styLNDesc" style="width:32mm;padding-left:1mm;height:6mm;"> Phone no. 
 								<xsl:call-template name="PopulateReturnHeaderPreparer">
										<xsl:with-param name="TargetNode">Phone</xsl:with-param>
										<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpPhoneNum</xsl:with-param>
									</xsl:call-template>
									<xsl:call-template name="PopulateReturnHeaderPreparer">
										<xsl:with-param name="TargetNode">ForeignPhone</xsl:with-param>
										<xsl:with-param name="BackupName">$RtnHdrDataPreparerPersonGrpForeignPhoneNum</xsl:with-param>
									</xsl:call-template>
								</div>
							</div>
						</div>
					</div>
					<!-- Page 1 Footer-->
					<div class="pageEnd" style="width:187mm;padding-top:1mm;clear:all;float:none;">
						<div style="float:left;">
							<span class="styBoldText">For Paperwork Reduction Act Notice, see separate instructions.</span>
							<span style="width:13mm;"/>                        
							  Cat. No. 64140B 
						</div>
						<div style="float:right;">
							<span style="width:40px;"/>  
						 Form <span class="styBoldText" style="font-size:8pt;">1120-RIC</span> (2025)
						</div>
					</div>
					<!-- Page 2 Header -->
					<div class="styBB" style="width:187mm;padding-top:.5mm;float:none;">
						<div style="float:left;">Form 1120-RIC (2025)<span style="width:148mm;"/>
						</div>
						<div style="float:right;">Page <span style="font-weight:bold;font-size:8pt;">2</span>
						</div>
					</div>
					<!-- Page 2 Part I -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartDesc" style="padding-left:0px;"><strong>Part I-Tax and Payments</strong> (see instructions)</div>
					</div>
					<div class="styBB" style="width:187mm;">
						<div class="styIRS1120VTImageBox" style="height:66mm;width:19px;padding-top:18mm">
							<img src="{$ImagePath}/1120RIC_TaxAndPayments.gif" alt="Vertical Income"/>
						</div>
						<!-- Part I line 27 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">27</div>
							<div class="styLNDesc" style="width:137mm;">
								<span style="float:left;clear:none;"><strong>Total tax.</strong> (Schedule J, line 9)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">........................</span>
							</div>
							<div class="styLNRightNumBox">27</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$IRS1120RICScheduleJ/TotalTaxAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I Line 28 -->
						<div style="width:181mm;float:right;clear:none;">
							<!-- Part I Line 28a -->
							<span class="styLNLeftNumBox"><strong>28a</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Preceding year's overpayment credited to the current year</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">......</span>
							</div>				
							<div class="styLNRightNumBox">28a</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/PriorYearOverpaymentCreditAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28b -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>b</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Current year's estimated tax payments</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">............</span>
							</div>				
							<div class="styLNRightNumBox">28b</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/EstimatedTaxPaymentsAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28c -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>c</strong></span>	
							<div class="styLNDesc" style="width:102mm;">
								<span>Current year's refund applied for on Form 4466</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..........</span>
							</div>		
							<div class="styLNRightNumBox" style="">28c</div>
							<div class="styLNAmountBox" style="width:27mm">
								<span>(</span>
									<span style="min-width:24mm;">
										<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/OverpaymentOfEstimatedTaxAmt"/>
										</xsl:call-template>
									</span>
								<span>)</span>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28d -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>d</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Tax deposited with Form 7004</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">...............</span>
							</div>				
							<div class="styLNRightNumBox">28d</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TaxPaidForm7004Amt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28e -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>e</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Credit for tax paid on undistributed capital gains (attach Form 2439)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/TotalUndistributedLTCapGainAmt"/>
								</xsl:call-template>
							</div>				
							<div class="styLNRightNumBox">28e</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalUndistributedLTCapGainAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28f -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>f</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Credit for federal tax paid on fuels (attach Form 4136)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.......</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/TotalFuelTaxCreditAmt"/>
								</xsl:call-template>
							</div>				
							<div class="styLNRightNumBox">28f</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalFuelTaxCreditAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28g -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>g</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Elective payment election amount from Form 3800</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">........</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/ElectivePaymentAmt"/>
								</xsl:call-template>
							</div>				
							<div class="styLNRightNumBox">28g</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/ElectivePaymentAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
							<!-- Part I Line 28z -->
							<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>z</strong></span>
							<div class="styLNDesc" style="width:102mm;">
								<span>Other credits and payments (see instructions-attach statement)</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/OtherCreditPaymentAmt"/>
								</xsl:call-template>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/OtherCreditPaymentAmt"/>
								</xsl:call-template>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/OtherCreditPaymentAmt"/>
								</xsl:call-template>
							</div>				
							<div class="styLNRightNumBox">28z</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/OtherCreditPaymentAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						</div>
						<!-- Part I line 29 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">29</div>
							<div class="styLNDesc" style="width:137mm;">
								<span style="float:left;clear:none;"><strong>Total payments and credits.</strong> Combine lines 28a through 28z</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">..............</span>
							</div>
							<div class="styLNRightNumBox">29</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalPaymentsAndCreditsAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 30 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">30</div>
							<div class="styLNDesc" style="width:132.1mm;">
								<span style="float:left;clear:none;">Estimated tax penalty (see instructions). Check if Form 2220 is attached</span>
								<span class="styDotLn" style="float:right;">.........</span>
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/Form2220AttachedInd"/>
								</xsl:call-template>							
							</div>
							<div style="float: left;">
								<input type="checkbox" alt="Final Return" class="styCkbox" style="height:2.4mm;" aria-label="Final Return">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/Form2220AttachedInd"/>
										<xsl:with-param name="BackupName">IRS1120RICForm2220AttachedInd</xsl:with-param>
									</xsl:call-template>
								</input>
							</div>
							<div class="styLNRightNumBox">30</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/EsPenaltyAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Part I line 31 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">31</div>
							<div class="styLNDesc" style="width:137mm;">
								<span style="float:left;clear:none;"><strong>Amount owed.</strong> If line 29 is smaller than the total of lines 27 and 30, enter amount owed</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.....</span>
							</div>
							<div class="styLNRightNumBox">31</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:choose>
									<xsl:when test="$FormData/BalanceDueAmt">
										<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/BalanceDueAmt"/>
										</xsl:call-template>
									</xsl:when>
								</xsl:choose>
							</div>
						</div>
						<!-- Part I line 32 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">32</div>
							<div class="styLNDesc" style="width:137mm;">
								<span style="float:left;clear:none;"><strong>Overpayment.</strong> If line 29 is larger than the total of lines 27 and 30, enter amount overpaid</span>
								<span class="styDotLn" style="float:right;padding-right:2mm;">.....</span>
							</div>
							<div class="styLNRightNumBox">32</div>
							<div class="styLNAmountBox" style="width:27mm">
								<xsl:choose>
									<xsl:when test="$FormData/OverpaymentSection/OverpaymentAmt">
										<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/OverpaymentSection/OverpaymentAmt"/>
										</xsl:call-template>
									</xsl:when>
								</xsl:choose>
							</div>
						</div>
						<!-- Part I line 33 -->
						<div style="width:181mm;float:right;clear:none;">
							<div class="styLNLeftNumBox">33</div>
							<div class="styLNDesc" style="width:93.2mm;">
								<span style="float:left;clear:none;">Enter amount from line 32:<strong> a Credited to 2026 estimated tax</strong></span>
								<span class="styDotLn" style="float:right;padding-right:1mm;">..</span>
							</div>
							<div style="float:left;width:24mm;min-height:3.5mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px;">
								<xsl:choose>
									<xsl:when test="$FormData/OverpaymentSection/AppliedToEsTaxAmt">
										<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/OverpaymentSection/AppliedToEsTaxAmt"/>
										</xsl:call-template>
									</xsl:when>
								</xsl:choose>
							</div>
							<div style="float: left;padding-right:2mm;padding-left:2mm;"><strong>b Refunded</strong></div>
							<div class="styLNRightNumBox">33b</div>
							<div class="styLNAmountBox" style="width:27mm;">
								<xsl:choose>
									<xsl:when test="$FormData/OverpaymentSection/RefundAmt">
										<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/OverpaymentSection/RefundAmt"/>
										</xsl:call-template>
									</xsl:when>
								</xsl:choose>
							</div>						
							<div style="width:187mm;">
								<span style="float:left;padding-left:8mm;padding-right:2mm;padding-top:1mm;"><strong>c</strong> Routing number </span>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="1"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="2"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="3"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="4"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="5"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="6"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="7"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="8"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/RoutingTransitNum"/>
										<xsl:with-param name="BoxNum" select="9"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>						
								<span style="padding-left:10mm;padding-right:2mm;"><strong>d</strong> Type: </span>
								<input type="Checkbox" class="styCkboxNM" alt="Checking Account Ind" aria-label="Checking Account">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/CheckingAccountInd"/>
										<xsl:with-param name="BackupName">IRS1120RICCheckingAccountInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="padding-left:2mm;padding-right:2mm;"> Checking </span>

								<input type="Checkbox" class="styCkboxNM" alt="Savings Account Ind" aria-label="Savings Account">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/SavingsAccountInd"/>
										<xsl:with-param name="BackupName">IRS1120RICSavingsAccountInd</xsl:with-param>
									</xsl:call-template>
								</input>								
								<span style="padding-left:2mm;"> Savings </span>			
							</div>
							<div style="width:187mm;padding-top:1mm;">
								<span style="float:left;padding-left:8mm;padding-right:2mm;padding-top:1mm;"><strong>e</strong> Account number </span>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="1"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="2"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="3"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="4"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="5"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="6"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="7"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="8"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="9"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="10"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="11"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="12"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="13"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="14"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="15"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="16"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>	
								<div>
									<xsl:call-template name="PopulateIndividualSizableLetterBox">
										<xsl:with-param name="TargetNode" select="$FormData/DirectDepositGrp/DepositorAccountNum"/>
										<xsl:with-param name="BoxNum" select="17"/>
										<xsl:with-param name="BoxWidth" select="'4mm'"/>
										<xsl:with-param name="BoxHeight" select="'4mm'"/>
										<xsl:with-param name="BoxTopPadding" select="'.5mm'"/>
									</xsl:call-template>
								</div>		
							</div>					
						</div>
					</div>					
					<!-- Page 2 Part II -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartDesc" style="padding-left:0px;">
						<strong>Part II-Tax on Undistributed Net Capital Gain Not Designated Under Section 852(b)(3)(D)</strong></div>
					</div>
					<!-- Part II line 1 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">1</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Net capital gain from Schedule D (Form 1120), line 17 (attach Schedule D (Form 1120))</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">......</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/NetGainOrLossAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox">1</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/NetGainOrLossAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part II line 2 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">2</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Capital gain dividends from Schedule A, line 8b</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">....................</span>
						</div>
						<div class="styLNRightNumBox">2</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$IRS1120RICScheduleA/CapitalGainsDividendAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part II line 3 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">3</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Subtract line 2 from line 1</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">..........................</span>
						</div>
						<div class="styLNRightNumBox">3</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalCapitalGainAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part II line 4 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">4</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;"><strong>Capital gains tax.</strong> Multiply line 3 by 21% (0.21). Enter tax here and on Schedule J, line 1b</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">......</span>
						</div>
						<div class="styLNRightNumBox" style="border-bottom-width:0px;">4</div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainsTaxAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule A -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:22mm;">Schedule A</div>
						<div class="styPartDesc" style="width:165mm;height:auto;font-weight:normal;">
							<strong>Deduction for Dividends Paid</strong> (Do not include exempt-interest dividends or capital gain dividends reported on Form 2438, line 9b. See instructions.)
						</div>
					</div>
					<!-- Schedule A line 1 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="height:7.5mm;padding-left:3mm">1</div>
						<div class="styLNDesc" style="width:125mm;padding-left:1mm;padding-bottom:0mm;height:7.5mm;">
							<span style="float:left;clear:none;height:7.5mm;">Dividends paid (other than dividends paid after the end of the tax year). Do not include <br/>
							dividends deemed paid in the preceding tax year under section 852(b)(7) or 855(a), or
							</span>
						</div>
						<div class="sty1120RICTitleBox"><strong>(a)</strong> Ordinary <br/> dividends</div>
						<div class="sty1120RICTitleBox"><strong>(b)</strong> Capital gain <br/> dividends</div>
						<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
						<div class="styLNDesc" style="width:117mm;padding-left:1mm;padding-top:0mm;">
							<span style="float:left;clear:none;">deficiency dividends as defined in section 860(f)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.............</span>
						</div>
						<div class="styLNRightNumBox" style="border-top-width:1px;">1</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/DividendsPaidAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/DividendsPaidAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule A Line 2 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="height:8mm;padding-left:3mm">2</div>
						<div class="styLNDesc" style="height:8mm;width:117mm;padding-left:1mm">
							<span style="float:left;clear:none;">Dividends paid in the 12-month period following the close of the tax year that the fund<br/></span>
							<span style="float:left;clear:none;"> elects to treat as paid during the tax year under section 855(a)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">........</span>	
						</div>
						<div class="styLNRightNumBox" style="height:8mm;padding-top:4mm;">2</div>
						<div class="styLNAmountBox" style="height:8mm;width:27mm;padding-top:4mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/DividendUnderSection855aAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="height:8mm;width:27mm;padding-top:4mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/DividendUnderSection855aAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule A Line 3 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="height:8mm;padding-left:3mm">3</div>
						<div class="styLNDesc" style="height:8mm;width:117mm;padding-left:1mm">
							<span style="float:left;clear:none;">Dividends declared in October, November, or December and deemed paid on December<br/></span>
							<span style="float:left;clear:none;">31 under section 852(b)(7) </span> 
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">...................</span>
						</div>
						<div class="styLNRightNumBox" style="height:8mm;padding-top:4mm;">3</div>
						<div class="styLNAmountBox" style="height:8mm;width:27mm;padding-top:4mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/DividendUnderSection852b7Amt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="height:8mm;width:27mm;padding-top:4mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/DividendUnderSection852b7Amt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule A line 4 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">4</div>
						<div class="styLNDesc" style="width:117mm;padding-left:1mm">
							<span style="float:left;clear:none;">Consent dividends (section 565) (attach Forms 972 and 973)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.....</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/ConsentDividendsAmt"/>
							</xsl:call-template>	
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/ConsentDividendsAmt"/>
							</xsl:call-template>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/ConsentDividendsAmt"/>
							</xsl:call-template>	
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/ConsentDividendsAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox">4</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/ConsentDividendsAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/ConsentDividendsAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule A line 5 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">5</div>
						<div class="styLNDesc" style="width:117mm;padding-left:1mm">
							<span style="float:left;clear:none;">Deficiency dividends (section 860) (attach Form 976)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.........</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/DeficiencyDivDeductionAmt"/>
							</xsl:call-template>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/DeficiencyDivDeductionAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox">5</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/DeficiencyDivDeductionAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/DeficiencyDivDeductionAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule A line 6 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">6</div>
						<div class="styLNDesc" style="width:117mm;padding-left:1mm">
							<span style="float:left;clear:none;">Foreign tax paid deduction (section 853(b)(1)(B)), if applicable</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">........</span>
						</div>
						<div class="styLNRightNumBox">6</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/ForeignTaxesPaidAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:27mm;background-color:lightgrey;"></div>	
					</div>
					<!-- Schedule A line 7 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">7</div>
						<div class="styLNDesc" style="width:117mm;padding-left:1mm">
							<span style="float:left;clear:none;">Credits from tax credit bonds distributed to shareholders (see instructions)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">....</span>
						</div>
						<div class="styLNRightNumBox">7</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/CreditsFromTaxCreditBondsAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:27mm;background-color:lightgrey;"></div>	
					</div>
					<!-- Schedule A line 8 -->
					<div style="width:187mm;float:right;clear:none;">
						<span class="styLNLeftNumBox" style="padding-left:3mm">8</span>
						<div class="styLNDesc" style="width:117mm;">
							<span>Deduction for dividends paid:</span>
						</div>				
						<div class="styLNRightNumBoxNBB"></div>
						<div class="styLNAmountBoxNBB" style="width:27mm">
						</div>
						<div class="styLNAmountBox" style="background-color:lightgrey;width:27mm;border-bottom:0px;"></div>
						<!-- Schedule A Line 8a-->
						<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>a</strong>
						</span>
						<div class="styLNDesc" style="width:117mm;font-size:6.9pt;">
							<span><strong>Ordinary dividends.</strong> Add lines 1 through 7 of column (a). Enter here and on Part I, line 25a</span>
						</div>				
						<div class="styLNRightNumBox">8a</div>
						<div class="styLNAmountBox" style="width:27mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OrdinaryDividendsGrp/TotalDeductionDividendsPaidAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:27mm;background-color:lightgrey;"></div>
						<!-- Schedule A Line 8b -->
						<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>b</strong></span>
						<div class="styLNDesc" style="width:117mm;">
							<span><strong>Capital gain dividends.</strong> Add column (b), lines 1 throuqh 5. Also enter on Part II, line 2</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">.</span>
						</div>				
						<div class="styLNRightNumBox" style="border-bottom-width:0px;">8b</div>
						<div class="styLNAmountBox" style="width:27mm;background-color:lightgrey;border-bottom-width:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CapitalGainDividendsGrp/CapitalGainsDividendAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule B -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:22mm;">Schedule B</div>
						<div class="styPartDesc" style="width:165mm;height:auto;font-weight:normal;">
							<strong>Information Required With Respect to Income From Tax-Exempt Obligations</strong>
						</div>
					</div>
					<!-- Schedule B line 1 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">1</div>
						<div class="styLNDesc" style="width:156mm;padding-left:1mm">
							<span style="float:left;clear:none;">Did the fund qualify under section 852(b)(5) or 852(g) to pay exempt-interest dividends for 2025?</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.......</span>
						</div>
						<div>
							<span style="float:right;padding-top:.5mm;">
								<input type="Checkbox" class="styCkboxNM" alt="Exempt Interest Dividends Yes"  aria-label="Exempt Interest Dividends Yes">
									<xsl:call-template name="PopulateYesCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/ExemptInterestDividendsInd"/>
										<xsl:with-param name="BackupName">IRS1120RICExemptInterestDividendsYesInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:1mm;"/>	
								<strong>Yes</strong>
								<span style="width:3mm;"/>								
								<input type="Checkbox" class="styCkboxNM" alt="Exempt Interest Dividends No"  aria-label="Exempt Interest Dividends No">
									<xsl:call-template name="PopulateNoCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/ExemptInterestDividendsInd"/>
										<xsl:with-param name="BackupName">IRS1120RICExemptInterestDividendsNoInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:1mm;"/>
								<strong>No</strong>
							</span>
						</div>
						<div class="styLNDesc" style="width:156mm;padding-left:9mm">
							<span style="float:left;clear:none;">If "Yes," complete lines 2 through 5.</span>
						</div>
					</div>
					<!-- Schedule B line 2 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">2</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Amount of interest excludable from gross income under section 103(a)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.............</span>	
						</div>
						<div class="styLNRightNumBox">2</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/ExcludedInterestAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule B line 3 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">3</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Amounts disallowed as deductions under sections 265 and 171(a)(2)</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.............</span>	
						</div>
						<div class="styLNRightNumBox">3</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/DisallowedSection265Amt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule B line 4 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">4</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Net income from tax-exempt obligations. Subtract line 3 from line 2</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">..............</span>	
						</div>
						<div class="styLNRightNumBox">4</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TaxExemptObligationsIncomeAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule B line 5 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm">5</div>
						<div class="styLNDesc" style="width:144mm;padding-left:1mm">
							<span style="float:left;clear:none;">Amount of line 4 designated as exempt-interest dividends</span>
							<span class="sty1120RICDotLn" style="float:right;padding-right:2mm;">.................</span>	
						</div>
						<div class="styLNRightNumBox" style="border-bottom-width:0px;">5</div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/ExemptInterestDividendsAmt"/>
							</xsl:call-template>
						</div>	
					</div>
					<!-- Schedule J -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:22mm;">Schedule J</div>
						<div class="styPartDesc" style="width:165mm;height:auto;font-weight:normal;">
							<strong>Tax Computation</strong> (see instructions)
						</div>
					</div>
					<!-- Schedule J Line 1 -->
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule J Line 1a -->
						<span class="styLNLeftNumBox" style="padding-left:3mm"><strong>1a</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Tax on investment company taxable income</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">............</span>
						</div>				
						<div class="styLNRightNumBox">1a</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/RICTaxableIncomeTaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1b -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>b</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Tax on undistributed net capital gain (from Part II, line 4)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">.......</span>
						</div>				
						<div class="styLNRightNumBox">1b</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$IRS1120RICScheduleJ/CapitalGainsTaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1c -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>c</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Tax imposed under section 851 (d)(2)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">.............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TaxImposedSect851d2Amt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox" style="">1c</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TaxImposedSect851d2Amt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1d -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>d</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Tax imposed under section 851 (i)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">..............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TaxImposedSect851iAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">1d</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TaxImposedSect851iAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1e -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>e</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Section 1291 tax from Form 8621</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">...............</span>
						</div>				
						<div class="styLNRightNumBox">1e</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/Section1291Amt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1f -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>f</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Additional tax under section 197(f)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">...............</span>
						</div>				
						<div class="styLNRightNumBox">1f</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/Section197Amt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1g -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>g</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Amount from Form 4255, Part I, line 3, column (q)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">.........</span>
						</div>				
						<div class="styLNRightNumBox">1g</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalChapter1TaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 1z -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>z</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Other chapter 1 tax</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">...................</span>
						</div>				
						<div class="styLNRightNumBox">1z</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OtherChapter1TaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
					</div>
					<!-- Schedule J Line 2 -->
					<div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"><strong>2</strong></span>
						<div class="styLNDesc" style="width:144mm;">
							<span><strong>Income tax.</strong> Add lines 1a through 1z</span>
							<span class="styDotLn" style="float:right;">........................</span>
						</div>				
						<div class="styLNRightNumBox">2</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/IncomeTaxAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule J Line 3 -->
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule J Line 3a -->
						<span class="styLNLeftNumBox" style="padding-left:3mm"><strong>3a</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Foreign tax credit (attach Form 1118)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">.............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/ForeignTaxCreditAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">3a</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/ForeignTaxCreditAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 3b -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>b</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Credit from Form 8834 (see instructions)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/QlfyElecMotorVehCrAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">3b</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/QlfyElecMotorVehCrAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 3c -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>c</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>General business credit (attach Form 3800)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">...........</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/CYGenBusinessCreditAllowedAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox" style="">3c</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CYGenBusinessCreditAllowedAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 3d -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>d</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Other credits (attach statement-see instructions)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">........</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherCreditsAmt"/>
							</xsl:call-template>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherCreditsAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">3d</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OtherCreditsAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
					</div>
					<!-- Schedule J Line 4 -->
					<div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"><strong>4</strong></span>
						<div class="styLNDesc" style="width:144mm;">
							<span><strong>Total credits.</strong> Add lines 3a through 3d</span>
							<span class="styDotLn" style="float:right;">.......................</span>
						</div>				
						<div class="styLNRightNumBox">4</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule J Line 5 -->
					<div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"><strong>5</strong></span>
						<div class="styLNDesc" style="width:144mm;">
							<span>Subtract line 4 from line 2</span>
							<span class="styDotLn" style="float:right;">...........................</span>
						</div>				
						<div class="styLNRightNumBox" style="border-bottom-width:0px;">5</div>
						<div class="styLNAmountBox" style="border-bottom-width:0px;width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TaxLessCreditsAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Page 2 Footer-->
					<div class="pageEnd" style="width:187mm;clear:all;float:none;">
						<div class="styBB" style="width:187mm;border-top-width:1px;border-bottom-width:0px;">
							<div style="float:right;">
								<span style="width:40px;"/>  
							 Form <span class="styBoldText" style="font-size:8pt;">1120-RIC</span> (2025)
							</div>
						</div>
					</div>
					<!-- Page 3 Header -->
					<div class="styBB" style="width:187mm;padding-top:.5mm;float:none;">
						<div style="float:left;">Form 1120-RIC (2025)<span style="width:148mm;"/>
						</div>
						<div style="float:right;">Page <span style="font-weight:bold;font-size:8pt;">3</span>
						</div>
					</div>
					<!-- Schedule J Continued-->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:22mm;">Schedule J</div>
						<div class="styPartDesc" style="width:165mm;height:auto;font-weight:normal;">
							<strong>Tax Computation</strong> (see instructions) <i>(continued)</i>
						</div>
					</div>
					<!-- Schedule J Line 6 -->
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule J Line 6a -->
						<span class="styLNLeftNumBox" style="padding-left:3mm"><strong>6a</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Personal holding company tax (attach Schedule PH (Form 1120))</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">....</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/PersonalHoldingCompanyTaxAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">6a</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/PersonalHoldingCompanyTaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 6b -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>b</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Interest on deferred tax liability for installment obligations under section 453A(c)</span>
						</div>				
						<div class="styLNRightNumBox">6b</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/InterestTaxDueSection453AcAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 6c -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>c</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Interest on deferred tax liability for installment obligations under section 453(I)(3)</span>
						</div>				
						<div class="styLNRightNumBox" style="">6c</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/InterestTaxDueSection453IAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 6d -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>d</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Amount from Form 4255, Part I, line 3, column (r)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">.........</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TotalNonChapter1TaxAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">6d</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalNonChapter1TaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 6z -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>z</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Other (see instructions-attach statement)</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherTaxAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox">6z</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/OtherTaxAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
					</div>
					<!-- Schedule J Line 7 -->
					<div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"><strong>7</strong></span>
						<div class="styLNDesc" style="width:144mm;">
							<span><strong>Total.</strong> Combine lines 6a through 6z</span>
							<span class="styDotLn" style="float:right;">........................</span>
						</div>				
						<div class="styLNRightNumBox">7</div>
						<div class="styLNAmountBox" style="width:27mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalOtherTaxesAndInterestAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule J Line 8 -->
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule J Line 8a -->
						<span class="styLNLeftNumBox" style="padding-left:3mm"><strong>8a</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Total tax before deferred taxes. Add lines 5 and 7</span>
							<span class="styDotLn" style="float:right;padding-right:2mm;">..........</span>
						</div>				
						<div class="styLNRightNumBox">8a</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotTaxBeforeDefrdTaxesAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
						<!-- Schedule J Line 8b -->
						<span class="styLNLeftNumBox" style="padding-left:5mm;"><strong>b</strong></span>
						<div class="styLNDesc" style="width:106mm;">
							<span>Deferred tax on the RIC's share of undistributed earnings of a qualified electing fund</span>
						</div>				
						<div class="styLNRightNumBox">8b</div>
						<div class="styLNAmountBox" style="width:30mm">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/DefrdTaxCorpUndistrEarnQEFAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBox" style="background-color:lightgrey;border-bottom:0px;"></div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;"></div>
					</div>
					<!-- Schedule J Line 9 -->
					<div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"><strong>9</strong></span>
						<div class="styLNDesc" style="width:144mm;">
							<span><strong>Total tax.</strong> Subtract line 8b from 8a. Enter here and on line 27</span>
							<span class="styDotLn" style="float:right;">...............</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TotalTaxAmt"/>
							</xsl:call-template>
						</div>				
						<div class="styLNRightNumBox" style="border-bottom:0px;">9</div>
						<div class="styLNAmountBox" style="width:27mm;border-bottom:0px;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalTaxAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule K -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:22mm;">Schedule K</div>
						<div class="styPartDesc" style="width:165mm;height:auto;font-weight:normal;">
							<strong>Other Information</strong> (see instructions)
						</div>
					</div>
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule K Line 1 -->
						<div class="styLNLeftNumBox" style="padding-left:3mm;padding-top:1mm;">1</div>
						<div class="styLNDesc" style="width:167mm;">Check method of accounting:
						<span style="width:4mm;"/>
						<span class="styBoldText">a</span>
						<span style="width:3mm;"/>
						<!-- Schedule K Line 1a -->
						<input type="Checkbox" class="styCkboxNM" alt="Method of Accounting cash"  aria-label="Method of Accounting cash">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/MethodOfAccountingCashInd"/>
								<xsl:with-param name="BackupName">IRS1120RICMethodOfAccountingCashInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:2mm;"/>
						Cash
						<span style="width:3mm;"/>
						<!-- Schedule K Line 1b -->
						<span class="styBoldText">b</span>
						<span style="width:3mm;"/>
						<input type="Checkbox" class="styCkboxNM" alt="Method of Accounting Accrual" aria-label="Method of Accounting Accrual">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/MethodOfAccountingAccrualInd"/>
								<xsl:with-param name="BackupName">IRS1120RICMethodOfAccountingAccrualInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:2mm;"/>
						Accrual
						<span style="width:3mm;"/>
						<!-- Schedule K Line 1c -->
						<span class="styBoldText">c</span>
						<span style="width:3mm;"/>
						<input type="Checkbox" class="styCkboxNM" alt="Method of Accounting Other" aria-label="Method of Accounting Other">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/MethodOfAccountingOtherInd"/>
								<xsl:with-param name="BackupName">IRS1120RICMethodOfAccountingOtherInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:2mm;"/>
						Other (specify):			
						<div style="width:48mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/methodOfAccountingOtherDesc"/>
							</xsl:call-template>
						</div>
						</div>
						<div class="styIRS1120RICYesNoBox">Yes</div>
						<div class="styIRS1120RICYesNoBox">No</div>
					</div>
					<!-- Schedule K Line 2 -->
					<div style="width:187mm;float:right;clear:none;">						
						<div class="styLNLeftNumBox" style="padding-left:3mm;">2</div>
						<div class="styLNDesc" style="width:167mm;">At
the end of the tax year, did the RIC own, directly or indirectly, 50% or more of the voting stock of a domestic corporation?
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Own50PctOrMoreVotingStkDomInd"/>
									<xsl:with-param name="BackupName">IRS1120RICOwn50PctOrMoreVotingStkDomIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Own50PctOrMoreVotingStkDomInd"/>
									<xsl:with-param name="BackupName">IRS1120RICOwn50PctOrMoreVotingStkDomIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">(For rules of attribution, see section 267(c).)
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/Own50PctOrMoreVotingStkDomInd"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">If "Yes," attach a statement showing (a) name and identification number, (b) percentage owned, and (c) taxable income or (loss)</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">before a net operating loss (NOL) and special deductions of such corporation for the tax year ending with or within your tax year.</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 3 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">3</div>
						<div class="styLNDesc" style="width:167mm;">Is the RIC a subsidiary in a parent-subsidiary controlled group?
						<span class="styDotLn" style="float:right;">.....................</span>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/ControlledGroupMemberInd"/>
									<xsl:with-param name="BackupName">IRS1120RICControlledGroupMemberIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/ControlledGroupMemberInd"/>
									<xsl:with-param name="BackupName">IRS1120RICControlledGroupMemberIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
					</div>
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNDesc" style="width:124mm;padding-left:8mm;">If "Yes," enter the employer identification number and the name of the parent corporation:</div>
						<div style="width:49mm;height:auto;border-bottom:1px dashed black;">
							<xsl:choose>
								<xsl:when test="$FormData/ParentCorporationEIN">
									<xsl:call-template name="PopulateEIN">
										<xsl:with-param name="TargetNode" select="$FormData/ParentCorporationEIN" />
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/MissingEINReasonCd" />
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>	
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						<div class="styLNDesc" style="width:165mm;border-bottom:1px dashed black;">
							<span>
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/ParentCorporationName/BusinessNameLine1Txt"/>
								</xsl:call-template>
								<xsl:if test="$FormData/ParentCorporationName/BusinessNameLine2Txt">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/ParentCorporationName/BusinessNameLine2Txt"/>
									</xsl:call-template>	
								</xsl:if>
							</span>
							<span style="padding-left:2mm;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/PrntCorporationNameControlTxt"/>
								</xsl:call-template>
							</span>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 4 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">4</div>
						<div class="styLNDesc" style="width:167mm;">At the end of the tax year, did any individual, partnership, corporation, estate, or trust own, directly or indirectly, 50% or
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">more of the RIC's voting stock? (For rules of attribution, see section 267(c).)
						<span class="styDotLn" style="float:right;">.................</span>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Own50PercentOrMoreVotingStkInd"/>
									<xsl:with-param name="BackupName">IRS1120RICOwn50PercentOrMoreVotingStkIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Own50PercentOrMoreVotingStkInd"/>
									<xsl:with-param name="BackupName">IRS1120RICOwn50PercentOrMoreVotingStkIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">If "Yes," attach a statement showing name and identification number. (Do not include any information already entered in 3
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/Own50PercentOrMoreVotingStkInd"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;padding-right:2mm;">
							above.) Enter percentage owned:					
						<div style="width:25mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/VotingStockOwnedPct"/>
							</xsl:call-template>
						</div>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 5 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">5</div>
						<div class="styLNDesc" style="width:167mm;">At any time during the tax year, did one foreign person own, directly or indirectly, at least 25% of:</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 5a -->
						<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>a</strong></span>
						<div class="styLNDesc" style="width:166mm;">
							<span>The total voting power of all classes of stock of the fund entitled to vote, <strong>or</strong></span>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 5b -->
						<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>b</strong></span>	
						<div class="styLNDesc" style="width:167mm;">The total value of all classes of stock of the fund?
						<span class="styDotLn" style="float:right;">..........................</span>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/FrgnOwn25PctTotVotingPowerInd"/>
									<xsl:with-param name="BackupName">IRS1120RICFrgnOwn25PctTotVotingPowerIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/FrgnOwn25PctTotVotingPowerInd"/>
									<xsl:with-param name="BackupName">IRS1120RICFrgnOwn25PctTotVotingPowerIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<div class="styLNDesc" style="width:60mm;padding-left:8.5mm;">If "Yes," enter:
							<span style="width:2mm;"/>
							<strong>(1)</strong> Percentage owned:
						</div>
						<div style="width:25mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/VotingStockForeignOwnedPct"/>
							</xsl:call-template>
						</div>
						<span style="width:3mm;"/>
						<strong>(2)</strong> Owner's country:
						<div style="width:57mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/ForeignOwnStockCountryCd"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:170mm;padding-left:8.5mm;">
							The fund may have to file Form 5472. Enter number of Forms 5472 attached:
							<div style="width:30mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalForm5472FiledCnt"/>
								</xsl:call-template>
							</div>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TotalForm5472FiledCnt"/>
							</xsl:call-template>
							<span style="width:25mm;"/>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 6 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">6</div>
						<div class="styLNDesc" style="width:167mm;">During this tax year, did the fund pay dividends (other than stock dividends and distributions in exchange for stock) in excess
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">of the fund's current and accumulated earnings and profits? See sections 301 and 316
						<span class="styDotLn" style="float:right;">..............</span>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/ExcessDividendsPaidInd"/>
									<xsl:with-param name="BackupName">IRS1120RICExcessDividendsPaidIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/ExcessDividendsPaidInd"/>
									<xsl:with-param name="BackupName">IRS1120RICExcessDividendsPaidIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<div class="styLNDesc" style="width:167mm;padding-left:8mm;">If "Yes," file Form 5452.
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/ExcessDividendsPaidInd"/>
							</xsl:call-template>
						</div>						
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 7 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">7</div>
						<div class="styLNDesc" style="width:162mm;">Check this box if the fund issued publicly offered debt instruments with original issue discount
							<span class="styDotLn" style="float:right;">..........</span>
						</div>
						<input type="Checkbox" class="styCkboxNM" alt="Offered Debt Instruments" aria-label="Offered Debt Instruments">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/OfferedDebtInstrumentsInd"/>
								<xsl:with-param name="BackupName">IRS1120RICOfferedDebtInstrumentsInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:170mm;padding-left:8mm;">If checked, the fund may have to file Form 8281.
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OfferedDebtInstrumentsInd"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 8 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">8</div>
						<div class="styLNDesc" style="width:135mm;">Enter the amount of tax-exempt interest received or accrued during the tax year
							<span class="styDotLn" style="float:right;">........</span>
						</div>
						<div style="width:30mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							$<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/TaxExemptInterestAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 9 -->
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule K Line 9a -->
						<div class="styLNLeftNumBox" style="padding-left:3mm;">9</div>
						<div class="styLNDesc" style="width:167mm;">If this return is being filed for a series fund (as defined in section 851 (g)(2)), enter:</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>a</strong></span>
						<div class="styLNDesc" style="width:165mm;">
							<span>The name of the RIC in which the fund is a series:</span>
							<span style="width:2mm;"></span>
							<div style="width:100mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/RICOrREITNm/BusinessNameLine1Txt"/>
								</xsl:call-template>
								<span style="2mm;"/>
								<xsl:if test="$FormData/RICOrREITNm/BusinessNameLine2Txt">								
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/RICOrREITNm/BusinessNameLine2Txt"/>
									</xsl:call-template>	
								</xsl:if>
							</div>		
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 9b -->
						<span class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>b</strong></span>
						<div class="styLNDesc" style="width:165mm;">
							<span>The date the RIC was incorporated or organized:</span>
							<span style="width:2mm;"></span>
							<div style="width:50mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/IncorporationDt"/>
								</xsl:call-template>
							</div>		
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 10 -->
					<div style="width:187mm;float:right;clear:none;">
						<!-- Schedule K Line 10a -->
						<div class="styLNLeftNumBox">10a</div>
						<div class="styLNDesc" style="width:167mm;"><strong>Section 853 election.</strong>
							Check this box if the fund meets the requirements of section 853(a) and section 901(k) <strong>and</strong> elects to pass
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"></span>
						<div class="styLNDesc" style="width:162mm;">
							through the deduction or credit for foreign taxes it paid to its shareholders. See instructions for details and requirements
							<span class="styDotLn" style="float:right;">..</span>							
						</div>
						<input type="Checkbox" class="styCkboxNM" alt="Section 853 Election" aria-label="Section 853 Election">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section853ElectionInd"/>
								<xsl:with-param name="BackupName">IRS1120RICSection853ElectionInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 10b -->
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>b</strong></div>	
						<div class="styLNDesc" style="width:167mm;"><strong>Section 852(g) election.</strong>
							Check this box if the fund meets the requirements of section 852(g) <strong>and</strong> elects the application of
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						<div class="styLNDesc" style="width:162mm;">
							section 853 without regard to the requirement of section 853(a)(1). See instructions for details and requirements
							<span class="styDotLn" style="float:right;">....</span>
						</div>
						<input type="Checkbox" class="styCkboxNM" alt="Section 852g Election" aria-label="Section 852g Election">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section852gElectionInd"/>
								<xsl:with-param name="BackupName">IRS1120RICSection852gElectionInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 11 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">11</div>
						<div class="styLNDesc" style="width:167mm;"><strong>Section 853A election.</strong>
							Check this box if the fund elects under section 853A to pass through credits from tax credit bonds
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"></span>
						<div class="styLNDesc" style="width:162mm;">
							to its shareholders. See instructions
							<span class="styDotLn" style="float:right;">.............................</span>							
						</div>
						<input type="Checkbox" class="styCkboxNM" alt="Section 853a Election" aria-label="Section 853a Election">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section853aElectionInd"/>
								<xsl:with-param name="BackupName">IRS1120RICSection853aElectionInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 12 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">12</div>
						<div class="styLNDesc" style="width:167mm;"><strong>Section 852(b)(8) election.</strong>
							Check this box if, for purposes of computing taxable income, the fund elects under section
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<span class="styLNLeftNumBox" style="padding-left:3mm;"></span>
						<div class="styLNDesc" style="width:162mm;">
							852(b)(8) to defer all or part of its post-October capital loss or late-year ordinary loss for this tax year
							<span class="styDotLn" style="float:right;">........</span>							
						</div>
						<input type="Checkbox" class="styCkboxNM" alt="Section 852b8 Election" aria-label="Section 852b8 Election">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section852b8ElectionInd"/>
								<xsl:with-param name="BackupName">IRS1120RICSection852b8ElectionInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNLeftNumBox"></div>
						<div class="styLNDesc" style="width:167mm;">If the election is made, enter the amounts deferred:</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 12a -->
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;">a</div>
						<div class="styLNDesc" style="width:167mm;"><span>Post-October capital loss:</span>
						<span style="width:2mm;"></span>
						<div style="width:50mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/PostOctoberCapitalLossAmt"/>
							</xsl:call-template>
						</div>	
						<span style="width:2mm;"></span>
						<!-- Schedule K Line 12b -->
						<strong>b</strong> Late-year ordinary loss:
						<div style="width:46mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/LateYearOrdinaryLossAmt"/>
							</xsl:call-template>
						</div>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 13 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">13</div>
						<div class="styLNDesc" style="width:167mm;">Did the RIC have an election under section 163(j) for any real property trade or business or any farming business in effect
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNDesc" style="width:175mm;padding-left:8mm;">during the tax year? See instructions
						<span class="styDotLn" style="float:right;">..............................</span>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Section163jElectionInd"/>
									<xsl:with-param name="BackupName">IRS1120RICSection163jElectionIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Section163jElectionInd"/>
									<xsl:with-param name="BackupName">IRS1120RICSection163jElectionIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
					</div>
					<!-- Schedule K Line 14 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">14</div>
						<div class="styLNDesc" style="width:167mm;">Does the RIC satisfy one or more of the following? See instructions. If "Yes," complete and attach Form 8990						
							<span class="styDotLn" style="float:right;">......</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/SatisfyOneOrMoreConditionsInd"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/SatisfyOneOrMoreConditionsInd"/>
									<xsl:with-param name="BackupName">IRS1120RICSatisfyOneOrMoreConditionsIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/SatisfyOneOrMoreConditionsInd"/>
									<xsl:with-param name="BackupName">IRS1120RICSatisfyOneOrMoreConditionsIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<!-- Schedule K Line 14a -->
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>a</strong></div>	
						<div class="styLNDesc" style="width:167mm;">
							The RIC owns a pass-through entity with current or prior year carryover excess business interest expense.
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 14b -->
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>b</strong></div>	
						<div class="styLNDesc" style="width:167mm;">
							The RIC's aggregate average annual gross receipts (determined under section 448(c)) for the 3 tax years preceding the
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;"></div>	
						<div class="styLNDesc" style="width:167mm;">
							current tax year are more than $31 million and the RIC has business interest expense.
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 14c -->
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>c</strong></div>	
						<div class="styLNDesc" style="width:167mm;">
							The RIC is a tax shelter and the RIC has business interest expense.
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<!-- Schedule K Line 14d -->
						<div class="styLNLeftNumBox" style="padding-left:4.5mm;"><strong>d</strong></div>	
						<div class="styLNDesc" style="width:167mm;">
							The RIC paid section 163(j) interest dividends for the tax year.
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 15 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">15</div>
						<div class="styLNDesc" style="width:167mm;">Does the corporation intend to self-certify as a qualified opportunity fund?						
							<span class="styDotLn" style="float:right;">..................</span>					
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Form8996AttachedInd"/>
									<xsl:with-param name="BackupName">IRS1120RICForm8996AttachedIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/Form8996AttachedInd"/>
									<xsl:with-param name="BackupName">IRS1120RICForm8996AttachedIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<div class="styLNLeftNumBox"></div>
						<div class="styLNDesc" style="width:167mm;">If "Yes," complete and attach Form 8996. Enter the amount (if any) from Form 8996, line 15						
							<span style="width:2mm;"></span>
							<div style="width:43mm;height:auto;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								$<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/QlfyOpportunityFundPenaltyAmt"/>
								</xsl:call-template>								
							</div>	
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/QlfyOpportunityFundPenaltyAmt"/>
							</xsl:call-template>						
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Schedule K Line 16 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">16</div>
						<div class="styLNDesc" style="width:167mm;">Is the RIC a member of a controlled group?						
							<span class="styDotLn" style="float:right;">............................</span>
						</div>
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateYesBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/MemberOfControlledGroupInd"/>
									<xsl:with-param name="BackupName">IRS1120RICMemberOfControlledGroupIndYes</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>	
						<div class="styIRS1120RICYesNoBox">
							<span style="font-weight:normal;">
								<xsl:call-template name="PopulateNoBoxText">
									<xsl:with-param name="TargetNode" select="$FormData/MemberOfControlledGroupInd"/>
									<xsl:with-param name="BackupName">IRS1120RICMemberOfControlledGroupIndNo</xsl:with-param>
								</xsl:call-template>
							</span>
						</div>
						<div class="styLNLeftNumBox"></div>
						<div class="styLNDesc" style="width:167mm;">If "Yes," attach Schedule O (Form 1120). See instructions.
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/MemberOfControlledGroupInd"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICSmallShadingBox"></div>
						<div class="styIRS1120RICSmallShadingBox"></div>
					</div>
					<!-- Page 3 Footer-->
					<div class="pageEnd" style="width:187mm;padding-top:1mm;clear:all;float:none;">
						<div class="styBB" style="width:187mm;border-top-width:1px;border-bottom-width:0px;">						
							<div style="float:right;">
								<span style="width:40px;"/>  
							 Form <span class="styBoldText" style="font-size:8pt;">1120-RIC</span> (2025)
							</div>
						</div>
					</div>
					<!-- Page 4 Header -->
					<div class="styBB" style="width:187mm;padding-top:.5mm;float:none;">
						<div style="float:left;">Form 1120-RIC (2025)<span style="width:148mm;"/>
						</div>
						<div style="float:right;">Page <span style="font-weight:bold;font-size:8pt;">4</span>
						</div>
					</div>
					<!-- Schedule L -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:20mm;">Schedule L</div>
						<div class="styPartDesc" style="width:58mm;height:auto;font-weight:normal;">
							<strong>Balance Sheets per Books</strong> 
						</div>
						<div style="width:108mm;float:right;">
						  <div class="styLNAmountBox" style="width:54mm;text-align:center;border-bottom-width:0px;">Beginning of tax year</div>
						  <div class="styLNAmountBox" style="width:54mm;text-align:center;border-bottom-width:0px;">End of tax year</div>
						</div>
					</div>
					<!-- Schedule L table title -->
					<div style="width:187mm;">
						<div class="styLNLeftNumBox" style="border-top:1px solid white;border-bottom-width:0px;"/>
						<div class="styGenericDiv" style="width:71mm;text-align:center;font-weight:bold;border-top-width:0px;">Assets</div>
						<div class="styIRS1120RICLNAmountBox" style="text-align:center;font-weight:bold;">(a)</div>
						<div class="styIRS1120RICLNAmountBox" style="text-align:center;font-weight:bold;">(b)</div>
						<div class="styIRS1120RICLNAmountBox" style="text-align:center;font-weight:bold;">(c)</div>
						<div class="styIRS1120RICLNAmountBox" style="text-align:center;font-weight:bold;">(d)</div>
					</div>
					<!-- Schedule L Line 1 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">1</div>
						<div class="styLNDesc" style="width:71mm;">Cash
						<span class="styDotLn" style="float:right;">................</span>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 1b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/CashBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 1d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/CashEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 2a -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">2a</div>
						<div class="styLNDesc" style="width:71mm;">Trade notes and accounts receivable
						<span class="styDotLn" style="float:right;">......</span>
						</div>						
						<!-- Schedule L Line 2a(a) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TradeNotesAccountsRcvblBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 2a(c) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TradeNotesAccountsRcvblEOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
					</div>
					<!-- Schedule L Line 2b -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:5mm;">b</div>
						<div class="styLNDesc" style="width:71mm;">Less allowance for bad debts
						<span class="styDotLn" style="float:right;">........</span>
						</div>						
						<!-- Schedule L Line 2b(a) -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/BadDebtAllowanceBOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>						
						<!-- Schedule L Line 2b(b) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/NetTradeNotesAcctRcvblBOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 2b(c) -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/BadDebtAllowanceEOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>
						<!-- Schedule L Line 2b(d) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/NetTradeNotesAcctRcvblEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 3 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">3</div>
						<div class="styLNDesc" style="width:71mm;">U.S. government obligations
						<span class="styDotLn" style="float:right;">........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 3b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/USGovernmentObligationsBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 3d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/USGovernmentObligationsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 4 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">4</div>
						<div class="styLNDesc" style="width:71mm;">Tax-exempt securities (see instructions)
						<span class="styDotLn" style="float:right;">.....</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 4b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TaxExemptSecuritiesBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 4d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TaxExemptSecuritiesEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 5 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">5</div>
						<div class="styLNDesc" style="width:71mm;">Other current assets (attach statement)
						<span class="styDotLn" style="float:right;">....</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/ItemizedOtherCurrentAssetsSchedule"/>
							</xsl:call-template>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherCurrentAssetsBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 5b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherCurrentAssetsBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherCurrentAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 5d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherCurrentAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 6 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">6</div>
						<div class="styLNDesc" style="width:71mm;">Loans to shareholders
						<span class="styDotLn" style="float:right;">..........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 6b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LoansToShareholdersBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 6d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LoansToShareholdersEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 7 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">7</div>
						<div class="styLNDesc" style="width:71mm;">Mortgage and real estate loans
						<span class="styDotLn" style="float:right;">........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 7b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/MortgageRealEstateLoansBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 7d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/MortgageRealEstateLoansEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 8 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">8</div>
						<div class="styLNDesc" style="width:71mm;">Other investments (attach statement)
						<span class="styDotLn" style="float:right;">.....</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherInvestmentsBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 8b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherInvestmentsBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherInvestmentsEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 8d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherInvestmentsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 9a -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:3mm;">9a</div>
						<div class="styLNDesc" style="width:71mm;">Buildings and other fixed depreciable assets
						<span class="styDotLn" style="float:right;">...</span>
						</div>						
						<!-- Schedule L Line 9a(a) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/BuildingOtherDeprecAstBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 9a(c) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/BuildingOtherDeprecAstEOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
					</div>
					<!-- Schedule L Line 9b -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:5mm;">b</div>
						<div class="styLNDesc" style="width:71mm;">Less accumulated depreciation
						<span class="styDotLn" style="float:right;">........</span>
						</div>						
						<!-- Schedule L Line 9b(a) -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/AccumulatedDepreciationBOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>						
						<!-- Schedule L Line 9b(b) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/NetDepreciableAssetsBOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 9b(c) -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/AccumulatedDepreciationEOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>	
						</div>
						<!-- Schedule L Line 9b(d) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/NetDepreciableAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 10 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">10</div>
						<div class="styLNDesc" style="width:71mm;">Land (net of any amortization)
						<span class="styDotLn" style="float:right;">........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 10b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LandBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 10d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LandEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 11a -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">11a</div>
						<div class="styLNDesc" style="width:71mm;">Intangible assets (amortizable only)
						<span class="styDotLn" style="float:right;">......</span>
						</div>						
						<!-- Schedule L Line 11a(a) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/IntangibleAssetsBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 11a(c) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/IntangibleAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
					</div>
					<!-- Schedule L Line 11b -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="padding-left:5mm;">b</div>
						<div class="styLNDesc" style="width:71mm;">Less accumulated amortization
						<span class="styDotLn" style="float:right;">........</span>
						</div>						
						<!-- Schedule L Line 11b(a) -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/AccumulatedAmortizationBOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>						
						<!-- Schedule L Line 11b(b) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/NetIntangibleAssetsBOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 11b(c) -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/AccumulatedAmortizationEOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>
						<!-- Schedule L Line 11b(d) -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/NetIntangibleAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 12 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">12</div>
						<div class="styLNDesc" style="width:71mm;">Other assets (attach statement)
						<span class="styDotLn" style="float:right;">.......</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherAssetsBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 12b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherAssetsBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 12d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 13 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox">13</div>
						<div class="styLNDesc" style="width:71mm;">Total assets
						<span class="styDotLn" style="float:right;">..............</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 13b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TotalAssetsBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 13d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TotalAssetsEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L table title -->
					<div class="styBB" style="width:187mm;border-top-width:1px;border-bottom-width:0px;">
						<div class="styLNLeftNumBox" style="border-top-width:1px;border-bottom-width:0px;"/>
						<div class="styGenericDiv" style="width:71mm;text-align:center;font-weight:bold;border-top-width:2px;">Liabilities and Shareholders' Equity</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;border-bottom-width:0px;"></div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;border-bottom-width:0px;"></div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;border-bottom-width:0px;"></div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;border-bottom-width:0px;"></div>
					</div>
					<!-- Schedule L Line 14 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">14</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Accounts payable
							<span class="styDotLn" style="float:right;">............</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 14b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/AccountsPayableBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 14d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/AccountsPayableEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 15 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">15</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Mortgages, notes, bonds payable in less than 1 year
							<span class="styDotLn" style="float:right;">.</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 15b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/ShortTermPayableBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 15d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/ShortTermPayableEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 16 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">16</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Other current liabilities (attach statement)
						<span class="styDotLn" style="float:right;">....</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
							   <xsl:with-param name="TargetNode" select="$FormData/OtherCurrentLiabilitiesBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 16b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherCurrentLiabilitiesBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
							   <xsl:with-param name="TargetNode" select="$FormData/OtherCurrentLiabilitiesEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 16d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherCurrentLiabilitiesEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 17 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">17</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Loans from shareholders
						<span class="styDotLn" style="float:right;">..........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 17b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LoansFromShareholdersBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 17d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LoansFromShareholdersEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 18 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">18</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Mortgages, notes, bonds payable in 1 year or more
							<span class="styDotLn" style="float:right;">.</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 18b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LongTermPayableBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 18d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/LongTermPayableEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 19 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">19</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Other liabilities (attach statement)
						<span class="styDotLn" style="float:right;">......</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherLiabilitiesBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 19b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherLiabilitiesBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/OtherLiabilitiesEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 19d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/OtherLiabilitiesEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 20 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">20</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Capital stock
						<span class="styDotLn" style="float:right;">.............</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 20b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/CapitalStockBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 20d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/CapitalStockEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 21 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">21</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Additional paid-in capital
						<span class="styDotLn" style="float:right;">.........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 21b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/AdditionalPaidInCapitalBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 21d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/AdditionalPaidInCapitalEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 22 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">22</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Retained earnings-Appropriated (attach statement)	
							<span class="styDotLn" style="float:right;">.</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/RetainedEarningsApprBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 22b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/RetainedEarningsApprBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/RetainedEarningsApprEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 22d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/RetainedEarningsApprEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 23 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">23</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Retained earnings-Unappropriated
						<span class="styDotLn" style="float:right;">......</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 23b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/RetainedEarningsUnapprBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 23d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/RetainedEarningsUnapprEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 24 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">24</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Adjustments to shareholders' equity (attach statement)	
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/AdjustmentToShrEqtyBOYAmt"/>
							</xsl:call-template>
						</div>										
						<!-- Schedule L Line 24b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/AdjustmentToShrEqtyBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;">
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/AdjustmentToShrEqtyEOYAmt"/>
							</xsl:call-template>
						</div>
						<!-- Schedule L Line 24d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/AdjustmentToShrEqtyEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Schedule L Line 25 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">25</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Less cost of treasury stock
						<span class="styDotLn" style="float:right;">.........</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 25b -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/CostOfTreasuryStockBOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 25d -->
						<div class="styIRS1120RICLNAmountBox">
							<span>(</span>
								<span style="min-width:24mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/CostOfTreasuryStockEOYAmt"/>
									</xsl:call-template>
								</span>
							<span>)</span>
						</div>
					</div>
					<!-- Schedule L Line 26 -->
					<div style="width:187mm;float:right;clear:none;">
						<div class="styLNLeftNumBox" style="border-top-width:0px;">26</div>
						<div class="styLNDesc" style="width:71mm;border-top-width:0px;">Total liabilities and shareholders' equity
						<span class="styDotLn" style="float:right;">.....</span>
						</div>	
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>										
						<!-- Schedule L Line 26b -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TotalLiabilitiesShrEqtyBOYAmt"/>
							</xsl:call-template>
						</div>
						<div class="styIRS1120RICLNAmountBox" style="background-color:lightgrey;"/>
						<!-- Schedule L Line 26d -->
						<div class="styIRS1120RICLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							  <xsl:with-param name="TargetNode" select="$FormData/TotalLiabilitiesShrEqtyEOYAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<div style="width:187mm;float:right;clear:none;">
					<div class="styLNDesc" style="width:187mm;"><strong>Note:</strong> The fund is not required to complete Schedules M-1 and M-2 if the total assets on Schedule L, line 13, column (d), are less than $25,000.</div>
					</div>
					<!-- Schedule M-1 -->
					<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
						<div class="styPartName" style="width:25mm;">Schedule M-1</div>
						<div class="styPartDesc" style="width:162mm;height:auto;font-weight:normal;">
							<strong>Reconciliation of Income (Loss) per Books With Income per Return</strong> (see instructions)
						</div>
					</div>				
					<div class="styBB" style="width:187mm;height:auto;border-bottom-width:1px;float:none;clear:both;">
					    <div class="styLblNameAddr" style="width:93.5mm;height:auto;border-top-width: 0px;border-bottom-width: 0px; border-left-width: 0px;border-right-width: 1px;float:left;clear:left;">
						<div class="styGenericDiv" style="width:93.5mm;">
							<!-- Schedule M-1 Line 1 -->
						    <div class="styLNLeftNumBox" style="padding-left:3mm;">1</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<span style="float:left">Net income (loss) per books</span>
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.....</div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/NetIncomeLossPerBooksAmt"/>
								</xsl:call-template>
						    </div>
						</div>
						<!-- Schedule M-1 Line 2-->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;">2</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<span style="float:left">Federal income tax (less built-in gains tax)</span>
							</div>
						    <div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/FederalIncomeTaxPerBooksAmt"/>
								</xsl:call-template>
						    </div>
						</div>
						<!-- Schedule M-1 Line 3-->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;">3</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								Excess of capital losses over capital gain
						    </div>							
						    <div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/ExcessCapLossesOverCapGainsAmt"/>
								</xsl:call-template>
						    </div>
						</div>
						<!-- Schedule M-1 Line 4 -->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;">4</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								Income subject to tax not recorded on 
								<xsl:call-template name="SetFormLinkInline">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotalTaxableIncmNotRecOnBksAmt"/>
								</xsl:call-template>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;border-right-width:1px;"/>			   
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								books this year (itemize):
								<div style="width:24mm;border-bottom:1px dashed black;clear: none;"></div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;border-right-width:1px;"/>			   
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;border-right-width:1px;"/>			   
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotalTaxableIncmNotRecOnBksAmt"/>
								</xsl:call-template>
							</div>	   
						</div>
						<!-- Schedule M-1 Line 5-->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;">5</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<span style="float:left">Expenses recorded on books this year not</span>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;border-right-width:1px;"/>	
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<span style="float:left">deducted on this return (itemize): </span>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;border-right-width:1px;"/>	
						</div>
						<!-- Schedule M-1 Line 5a-->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:5mm;">a</div>
						    <div class="styLNDesc" style="width:31mm;">
								Depreciation
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">...</div>	
							</div>
						    $
						    <div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							    <xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/DepreciationExpensesAmt"/>
							    </xsl:call-template>
							</div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;border-right-width:1px;"/>	
						</div>
						<!-- Schedule M-1 Line 5b -->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:5mm;">b</div>
						    <div class="styLNDesc" style="width:58.5mm;">			    
								<span style="float:left;">Expenses allocable to tax-exempt interest</span>	
						    </div>				
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;border-right-width:1px;"/>
						</div>	
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBoxSD" style="padding-left: 4.25mm"></div>
						    <div class="styLNDesc" style="width:31mm;">income
							    <div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.....</div>	
						    </div>
						    $
						    <div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							    <xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/ExpensesAllcblTaxExemptIntAmt"/>
							    </xsl:call-template>
							</div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;border-right-width:1px;"/>
						</div>
						<!-- Scheduleh M-1 Line 5c -->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:5mm;">c</div>
						    <div class="styLNDesc" style="width:31mm;">Section 4982 tax
							    <div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">..</div>			
						    </div>
						    $
						    <div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							    <xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/Section4982TaxAmt"/>
							    </xsl:call-template>
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;border-right-width:1px;"/>
						</div>
						<!-- Schedule M-1 Line 5d -->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:5mm;">d</div>
						    <div class="styLNDesc" style="width:31mm;font-family:arial;">Travel and entertainment</div>
						    $
							<div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TravelEntertainmentAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;border-right-width:1px;"/>	
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;border-right-width:1px;"/>			   
						</div>						
						<div class="styGenericDiv" style="width:93.5mm;">
							 <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
									<xsl:call-template name="SetFormLinkInline">
										<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotalExpensesNotDeductedAmt"/>
									</xsl:call-template>
								</div>
						    </div>							
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotalExpensesNotDeductedAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Schedule M-1 Line 6-->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;">6</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<span style="float:left">Add lines 1 through 5</span>
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.......</div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;border-bottom-width: 0px;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/IncomeExpensesSubtotalAmt"/>
								</xsl:call-template>
						    </div>
						</div>
					</div>
					<div class="styLblNameAddr" style="width:93mm;height:38mm;border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px;border-right-width: 0px;">
					    <!-- Schedule M-1 Line 7-->
					    <div class="styGenericDiv" style="width:93mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm">7</div>
							<div class="styLNDesc" style="width:58mm;">
								Income recorded on books this year
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;"/>
					    </div>
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
							<div class="styLNDesc" style="width:58mm;">				 
								not included on this return (itemize):
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;"/>
						</div>
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
							<div class="styLNDesc" style="width:30mm;">Tax-exempt interest</div>
							$
							<div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TaxExemptInterestAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>
						</div>
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
							<div class="styLNDesc" style="width:58mm;">
								<div style="width:56.5mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
									<xsl:call-template name="SetFormLinkInline">
										<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotIncmRecordedNotIncludedAmt"/>
									</xsl:call-template>
								</div>
							</div>							
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotIncmRecordedNotIncludedAmt"/>
								</xsl:call-template>
							</div>
						</div>  					 
					    <!-- Schedule M-1 Line 8 -->
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">8</div>
							<div class="styLNDesc" style="width:58mm;">
								Deductions on this return not charged </div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>
					    </div>
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
							<div class="styLNDesc" style="width:58mm;">
								against book income this year (itemized): </div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>
					    </div>
					    <!-- Schedule M-1 Line 8a -->
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:5mm">a</div>
							<div class="styLNDesc" style="width:30mm;">Depreciation</div>
							$
							<div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/DepreciationDeductionAmt"/>
								</xsl:call-template>
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>
						</div>
						<!-- Schedule M-1 Line 8b -->
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:5mm">b</div>
							<div class="styLNDesc" style="width:53mm;">
								Deduction for dividends paid (Part I,</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>
					    </div>
					    <div class="styGenericDiv" style="width:93mm;">
						    <div class="styLNLeftNumBox" style="padding-left:5mm;"></div>
						    <div class="styLNDesc" style="width:30mm;">
								line 25a)
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">....</div>	
							</div>
						    $
						    <div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							    <xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotalDeductionDividendsPaidAmt"/>
							    </xsl:call-template>
							</div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>	
						</div>
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
							<div class="styLNDesc" style="width:58mm;">
								<div style="width:56.5mm;padding-left:4mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
							</div>							
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/TotalDeductionsAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Schedule M-1 Line 9-->
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">9</div>
							<div class="styLNDesc" style="width:58mm;">
								Net capital gain from Form 2438, line 9a</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								   <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/NetCapitalGainAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Schedule M-1 Line 10 -->
						<div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">10</div>
							<div class="styLNDesc" style="width:58mm;">
							    If the fund did not file Form 2438, enter
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>	
					    </div>
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
							<div class="styLNDesc" style="width:58mm;">
							    the net capital gain from Schedule D
							</div>
							<div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>	
					    </div>
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
							<div class="styLNDesc" style="width:58mm;">
							    (Form 1120), line 17. Otherwise, enter-0-
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								   <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/BuiltInGainsTaxableIncomeAmt"/>
								</xsl:call-template>
							</div>	
					    </div>
					    <!-- Schedule M-1 Line 11 -->
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">11</div>
							<div class="styLNDesc" style="width:58mm;">
							    Add lines 7 through 10
							    <div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.......</div>
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								   <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/IncomeDeductionsSubtotalAmt"/>
								</xsl:call-template>
							</div>	
					    </div>
					    <!-- Schedule M-1 Line 12 -->
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">12</div>
							<div class="styLNDesc" style="width:58mm;">
							    Investment company taxable income
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;border-bottom-width:0px;">
							</div>	
					    </div>
					    <div class="styGenericDiv" style="width:93mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
							<div class="styLNDesc" style="width:58mm;">
							    (Part I, line 26)-line 6 less line 11
							    <div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">...</div>
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;border-bottom-width:0px;">
								<xsl:call-template name="PopulateAmount">
								   <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM1Grp/RICTaxableIncomeAmt"/>
								</xsl:call-template>
							</div>	
					    </div>
					</div>
				</div>
				<!-- Schedule M-2 -->
				<div class="styBB" style="width:187mm;border-right-width:0px;border-top-width:1px;">
					<div class="styPartName" style="width:25mm;">Schedule M-2</div>
					<div class="styPartDesc" style="width:162mm;height:auto;font-weight:normal;">
						<strong>Analysis of Unappropriated Retained Earnings per Books (Schedule L, Line 23)</strong> 
					</div>
				</div>
				<div class="styBB" style="width:187mm;hight:28mm;border-bottom-width:1px;float:left;clear:left;">
					<div class="styLblNameAddr" style="width:93.5mm;height:28mm;border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px;border-right-width: 0px;">
						<!-- Schedule M-2 Line 1 -->
						<div class="styGenericDiv" style="width:93.5mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">1</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								Balance at beginning of year
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.....</div>
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/BeginningYearBalanceAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Schedule M-2 Line 2 -->
						<div class="styGenericDiv" style="width:93.5mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">2</div>
							<div class="styLNDesc" style="width:58.5mm;">
								Net income (loss) per books
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.....</div>
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/NetIncomeLossPerBooksAmt"/>
								</xsl:call-template>
							</div>
						</div>
						<!-- Schedule M-2 Line 3 -->
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm">3</div>
						    <div class="styLNDesc" style="width:33mm;">Other increases (itemize):</div>
							<div style="width:24mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
							</div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;float:right;"/>
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;"/>			   
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;border-bottom-width:0px;background-color:lightgrey;"/>			   
						</div>
						<div class="styGenericDiv" style="width:93.5mm;">
						    <div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
						    <div class="styLNDesc" style="width:58.5mm;">
								<div style="width:57mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
									<xsl:call-template name="SetFormLinkInline">
										<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/TotalOtherIncreasesAmt"/>
									</xsl:call-template>
								</div>
						    </div>
						    <div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/TotalOtherIncreasesAmt"/>
								</xsl:call-template>
							</div>		   
						</div>	
						<!-- Schedule M-2 Line 4 -->
						<div class="styGenericDiv" style="width:93.5mm;">
							<div class="styLNLeftNumBox" style="padding-left:3mm">4</div>
						    <div class="styLNDesc" style="width:58.5mm;">
								Add lines 1, 2, and 3
								<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.......</div>
							</div>
							<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;border-bottom-width:0px;">
								<xsl:call-template name="PopulateAmount">
								  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/BalanceIncomeOtherIncreasesAmt"/>
								</xsl:call-template>
							</div>
						</div>	
						</div>
						<div class="styLblNameAddr" style="width:93mm;height:28mm;border-top-width: 0px; border-bottom-width: 0px; border-left-width: 1px;border-right-width: 0px;">
							<!-- Schedule M-2 Line 5 -->
							<div class="styGenericDiv" style="width:93mm;">
							    <div class="styLNLeftNumBox" style="padding-left:3mm">5</div>
							    <!-- Schedule M-2 Line 5a -->
							    <div class="styLNDesc" style="width:58mm;">Distributions:<span style="width:3mm"/>
									<b>a</b><span style="width:3mm"/>Cash
									<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">......</div>
							    </div>
							    <div class="styLNAmountBox" style="width:27mm;">
									<xsl:call-template name="PopulateAmount">
										<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/CashDistributionAmt"/>
									</xsl:call-template>
								</div>
						    </div>
						    <!-- Schedule M-2 Line 5b -->
							<div class="styGenericDiv" style="width:93mm;">
								<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
								<div class="styLNDesc" style="width:58mm;">
									<span style="width:20mm"/>
									<b>b</b>
									<span style="width:3mm"/>Stock 								
								    <div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">......</div>
								</div>
								<div class="styLNAmountBox" style="width:27mm;">
								  <xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/StockDistributionAmt"/>
								  </xsl:call-template>
								</div>
						    </div>
						    <!-- Schedule M-2 Line 5c -->
							<div class="styGenericDiv" style="width:93mm;">
								<div class="styLNLeftNumBox" style="padding-left:3mm"></div>
								<div class="styLNDesc" style="width:58mm;">
									<span style="width:20mm"/>
									<b>c</b>
									<span style="width:3mm"/>Property 								
								    <div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">.....</div>
								</div>
								<div class="styLNAmountBox" style="width:27mm;">
								  <xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/PropertyDistributionAmt"/>
								  </xsl:call-template>
								</div>
						    </div>
						    <!-- Schedule M-2 Line 6 -->
							<div class="styGenericDiv" style="width:93mm;">
								<div class="styLNLeftNumBox" style="padding-left:3mm">6</div>
								<div class="styLNDesc" style="width:35mm;">Other decreases (itemize):</div>
								<div style="width:21.5mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;"></div>
								<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;float:right;border-bottom-width:0px;"></div>
							</div>
							<div class="styGenericDiv" style="width:93mm;">
								<div class="styLNLeftNumBox" style="padding-left:3mm;"></div>
								<div class="styLNDesc" style="width:58mm;">
									<div style="width:56.5mm;border-bottom:1px dashed black;margin-bottom:1px; clear: none;">
										<xsl:call-template name="SetFormLinkInline">
											<xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/TotalOtherDecreasesAmt"/>
										</xsl:call-template>
									</div>
								</div>							
								<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/TotalOtherDecreasesAmt"/>
									</xsl:call-template>
								</div>
							</div>
							<!-- Schedule M-2 Line 7 -->
						    <div class="styGenericDiv" style="width:93mm;">
								<div class="styLNLeftNumBox" style="padding-left:3mm">7</div>
								<div class="styLNDesc" style="width:58mm;">Add lines 5 and 6
									<div class="sty1120RICDotLn" style="float:right;padding-right:1mm;">........</div>
								</div>
								<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/DistributionsOtherDecreasesAmt"/>
									</xsl:call-template>
								</div>
							</div>
							<!-- Schedule M-2 Line 8 -->
							<div class="styGenericDiv" style="width:93mm;">
								<div class="styLNLeftNumBox" style="padding-left:3mm">8</div>
								<div class="styLNDesc" style="width:58mm;">Balance at end of year (line 4 less line 7)</div>
								<div class="styLNAmountBox" style="width:27mm;padding-right:.5mm;border-bottom-width:0px;">
									<xsl:call-template name="PopulateAmount">
									  <xsl:with-param name="TargetNode" select="$FormData/IRS1120RICScheduleM2Grp/EndYearBalanceAmt"/>
									</xsl:call-template>
								</div>
							</div>							   
						</div>
					</div>
					<!-- Page 4 Footer-->
					<div class="pageEnd" style="width:187mm;padding-top:1mm;clear:all;float:none;">
						<div style="float:right;">
							<span style="width:40px;"/>  
						 Form <span class="styBoldText" style="font-size:8pt;">1120-RIC</span> (2025)
						</div>
					</div>	
					<!-- Additonal   Data Title Bar and Button -->
					 <div class="styLeftOverTitleLine" id="LeftoverData">
						<div class="styLeftOverTitle">Additional Data</div>
						<div class="styLeftOverButtonContainer">
						  <input class="styLeftoverTableBtn" type="button" TabIndex="-1" value="Return to Form" onclick="javascript:returnToWriteInImage();"/>
						</div>
					</div>	
					<!-- Additional Data Table -->
					<table class="styLeftOverTbl">
						<xsl:call-template name="PopulateCommonLeftover">
						    <xsl:with-param name="TargetNode" select="$FormData"/>
						    <xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
						<xsl:call-template name="PopulateLeftoverRow">
						    <xsl:with-param name="Desc">Line 7 - Other income Description:</xsl:with-param>
						    <xsl:with-param name="TargetNode" select="$FormData/otherIncomeDesc"/>
						    <xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
						<xsl:call-template name="PopulateLeftoverRow">
						    <xsl:with-param name="Desc">Line E4 - FILED PURSUANT TO SECTION 301.9100-2</xsl:with-param>
						    <xsl:with-param name="TargetNode" select="$FormData/filedPursuantToSect30191002Cd"/>
						    <xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
						<xsl:call-template name="PopulateLeftoverRowAmount">
						    <xsl:with-param name="Desc">Line 28z - Backup Withholding Amount</xsl:with-param>
						    <xsl:with-param name="TargetNode" select="$FormData/backupWithholdingAmt"/>
						    <xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
					</table>
				</form>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>